/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.sasl.util.SSLQueryCallbackHandler;

public final class SSLSaslClientFactory
extends AbstractDelegatingSaslClientFactory
implements SaslClientFactory {
    private final Supplier<SSLSession> sslSession;

    public SSLSaslClientFactory(SaslClientFactory delegate, Supplier<SSLSession> sslSession) {
        super(delegate);
        this.sslSession = (Supplier)Assert.checkNotNullParam((String)"sslSession", sslSession);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SSLQueryCallbackHandler newHandler = new SSLQueryCallbackHandler(cbh, this.sslSession);
        SaslClient saslClient = super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, newHandler);
        newHandler.activate();
        return saslClient;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SSLSaslClientFactory && this.equals((SSLSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof SSLSaslClientFactory && this.equals((SSLSaslClientFactory)other);
    }

    public boolean equals(SSLSaslClientFactory other) {
        return super.equals(other) && Objects.equals(this.sslSession, other.sslSession);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)super.calculateHashCode(), (int)this.getClass().hashCode()), (int)Objects.hashCode(this.sslSession));
    }
}

