/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.wildfly.swarm.spi.api.JBossDeploymentStructureAsset;
import org.wildfly.swarm.spi.api.Module;

public interface JBossDeploymentStructureContainer<T extends Archive<T>>
extends Archive<T> {
    public static final String PRIMARY_JBOSS_DEPLOYMENT_DESCRIPTOR_PATH = "META-INF/jboss-deployment-structure.xml";
    public static final String SECONDARY_JBOSS_DEPLOYMENT_DESCRIPTOR_PATH = "WEB-INF/jboss-deployment-structure.xml";

    default public Module addModule(String name) {
        return this.getDescriptorAsset().addModule(name);
    }

    default public Module addModule(String name, String slot) {
        return this.getDescriptorAsset().addModule(name, slot);
    }

    default public T excludeModule(String name) {
        return this.excludeModule(name, "main");
    }

    default public T excludeModule(String name, String slot) {
        this.getDescriptorAsset().excludeModule(name, slot);
        return (T)this;
    }

    default public JBossDeploymentStructureAsset getDescriptorAsset() {
        Asset asset;
        String path = PRIMARY_JBOSS_DEPLOYMENT_DESCRIPTOR_PATH;
        Node jbossDS = this.get(PRIMARY_JBOSS_DEPLOYMENT_DESCRIPTOR_PATH);
        if (jbossDS == null && (jbossDS = this.get(SECONDARY_JBOSS_DEPLOYMENT_DESCRIPTOR_PATH)) != null) {
            path = SECONDARY_JBOSS_DEPLOYMENT_DESCRIPTOR_PATH;
        }
        if (jbossDS == null) {
            asset = new JBossDeploymentStructureAsset();
        } else {
            asset = jbossDS.getAsset();
            if (!(asset instanceof JBossDeploymentStructureAsset)) {
                asset = new JBossDeploymentStructureAsset(asset.openStream());
            }
        }
        this.add(asset, path);
        return (JBossDeploymentStructureAsset)asset;
    }
}

