/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.wildfly.swarm.spi.api.cdi.CommonBean;

public class CommonBeanBuilder<T> {
    private Class<?> beanClass;
    private Class<? extends Annotation> scope;
    private Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Supplier<T> createSupplier;
    private Set<Type> types = new HashSet<Type>();

    CommonBeanBuilder() {
    }

    public static <B> CommonBeanBuilder<B> newBuilder(Class<B> beanClass) {
        return new CommonBeanBuilder();
    }

    public CommonBeanBuilder<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public CommonBeanBuilder<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public CommonBeanBuilder<T> addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    public CommonBeanBuilder<T> createSupplier(Supplier<T> createSupplier) {
        this.createSupplier = createSupplier;
        return this;
    }

    public CommonBeanBuilder<T> addType(Type type) {
        this.types.add(type);
        return this;
    }

    public CommonBean<T> build() {
        return new CommonBean<T>(this.beanClass, this.scope, this.qualifiers, this.createSupplier, this.types.toArray(new Type[this.types.size()]));
    }
}

