/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.CacheCapabilityServiceConfiguratorFactory;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class CacheRequirementServiceConfiguratorProvider<T>
implements CacheServiceConfiguratorProvider {
    private final ClusteringCacheRequirement requirement;
    private final CacheCapabilityServiceConfiguratorFactory<T> factory;
    private final BiFunction<String, String, JndiName> jndiNameFactory;

    protected CacheRequirementServiceConfiguratorProvider(ClusteringCacheRequirement requirement, CacheCapabilityServiceConfiguratorFactory<T> factory) {
        this(requirement, factory, null);
    }

    protected CacheRequirementServiceConfiguratorProvider(ClusteringCacheRequirement requirement, CacheCapabilityServiceConfiguratorFactory<T> factory, BiFunction<String, String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.factory = factory;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Collection<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String cacheName) {
        ServiceName name = registry.getServiceName((Requirement)this.requirement);
        CapabilityServiceConfigurator configurator = this.factory.createServiceConfigurator(name, containerName, cacheName);
        if (this.jndiNameFactory == null) {
            return Collections.singleton(configurator);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(containerName, cacheName).getAbsoluteName());
        BinderServiceConfigurator binderConfigurator = new BinderServiceConfigurator(binding, configurator.getServiceName());
        return Arrays.asList(configurator, binderConfigurator);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

