/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;

public class InfinispanWebLogger_$logger
extends DelegatingBasicLogger
implements InfinispanWebLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanWebLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public InfinispanWebLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void failedToPassivateSession(Throwable cause, String sessionId) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToPassivateSession$str(), (Object)sessionId);
    }

    protected String failedToPassivateSession$str() {
        return "WFLYCLWEBINF0001: Failed to passivate attributes of session %s";
    }

    @Override
    public final void failedToPassivateSessionAttribute(Throwable cause, String sessionId, String attribute) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToPassivateSessionAttribute$str(), (Object)sessionId, (Object)attribute);
    }

    protected String failedToPassivateSessionAttribute$str() {
        return "WFLYCLWEBINF0002: Failed to passivate attribute %2$s of session %1$s";
    }

    protected String invalidSession$str() {
        return "WFLYCLWEBINF0003: Session %s is not valid";
    }

    @Override
    public final IllegalStateException invalidSession(String sessionId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidSession$str(), sessionId));
        InfinispanWebLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void failedToExpireSession(Throwable cause, String sessionId) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToExpireSession$str(), (Object)sessionId);
    }

    protected String failedToExpireSession$str() {
        return "WFLYCLWEBINF0004: Failed to expire session %s";
    }

    @Override
    public final void failedToCancelSession(Throwable cause, String sessionId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.failedToCancelSession$str(), (Object)sessionId);
    }

    protected String failedToCancelSession$str() {
        return "WFLYCLWEBINF0005: Failed to cancel expiration/passivation of session %s on primary owner.";
    }

    @Override
    public final void failedToScheduleSession(Throwable cause, String sessionId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.failedToScheduleSession$str(), (Object)sessionId);
    }

    protected String failedToScheduleSession$str() {
        return "WFLYCLWEBINF0006: Failed to schedule expiration/passivation of session %s on primary owner.";
    }

    @Override
    public final void failedToActivateSession(Throwable cause, String sessionId) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToActivateSession$str(), (Object)sessionId);
    }

    protected String failedToActivateSession$str() {
        return "WFLYCLWEBINF0007: Failed to activate attributes of session %s";
    }

    @Override
    public final void failedToActivateSessionAttribute(Throwable cause, String sessionId, String attribute) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToActivateSessionAttribute$str(), (Object)sessionId, (Object)attribute);
    }

    protected String failedToActivateSessionAttribute$str() {
        return "WFLYCLWEBINF0008: Failed to activate attribute %2$s of session %1$s";
    }

    protected String failedToReadSessionAttribute$str() {
        return "WFLYCLWEBINF0009: Failed to read attribute %2$s of session %1$s";
    }

    @Override
    public final IllegalStateException failedToReadSessionAttribute(Throwable cause, String sessionId, String attribute) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToReadSessionAttribute$str(), sessionId, attribute), cause);
        InfinispanWebLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToActivateAuthentication(Throwable cause, String ssoId) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToActivateAuthentication$str(), (Object)ssoId);
    }

    protected String failedToActivateAuthentication$str() {
        return "WFLYCLWEBINF0010: Failed to activate authentication for single sign on %s";
    }

    @Override
    public final void missingSessionAttributeCacheEntry(String sessionId, String attribute) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingSessionAttributeCacheEntry$str(), (Object)sessionId, (Object)attribute);
    }

    protected String missingSessionAttributeCacheEntry$str() {
        return "WFLYCLWEBINF0011: Session %s is missing cache entry for attribute %s";
    }

    @Override
    public final void evictionDisabled(String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.evictionDisabled$str(), (Object)cacheName);
    }

    protected String evictionDisabled$str() {
        return "WFLYCLWEBINF0012: Disabling eviction for cache '%s'. Web session passivation should be configured via <max-active-sessions/> in jboss-web.xml.";
    }

    @Override
    public final void expirationDisabled(String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.expirationDisabled$str(), (Object)cacheName);
    }

    protected String expirationDisabled$str() {
        return "WFLYCLWEBINF0013: Disabling expiration for cache '%s'. Web session expiration should be configured per \u00a77.5 of the servlet specification.";
    }
}

