/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PropertyValidator
extends ModelTypeValidator {
    private final ParameterValidator valueValidator;

    public PropertyValidator(boolean nullable, ParameterValidator valueValidator) {
        super(ModelType.PROPERTY, nullable);
        this.valueValidator = valueValidator;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            if (value.asProperty().getName().length() < 1) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidMinLength(value.asProperty().getName(), parameterName, 1)));
            }
            if (this.valueValidator != null) {
                this.valueValidator.validateParameter(parameterName, value.asProperty().getValue());
            }
        }
    }
}

