/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password.simple;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordStrength;
import org.jboss.as.domain.management.security.password.PasswordStrengthCheckResult;

public class SimplePasswordStrengthCheckResult
implements PasswordStrengthCheckResult {
    private PasswordStrength strength;
    private List<PasswordRestriction> failedRestrictions = new ArrayList<PasswordRestriction>();
    private List<PasswordRestriction> passedRestrictions = new ArrayList<PasswordRestriction>();
    private int positive = 0;
    private int negative = 0;
    private static final float BOUNDRY_EXCEPTIONAL = 0.03f;
    private static final float BOUNDRY_VERY_STRONG = 0.1f;
    private static final float BOUNDRY_STRONG = 0.15f;
    private static final float BOUNDRY_MEDIUM = 0.5f;
    private static final float BOUNDRY_MODERATE = 0.7f;
    private static final float BOUNDRY_WEAK = 0.9f;

    @Override
    public PasswordStrength getStrength() {
        return this.strength;
    }

    @Override
    public List<PasswordRestriction> getFailedRestrictions() {
        return this.failedRestrictions;
    }

    @Override
    public List<PasswordRestriction> getPassedRestrictions() {
        return this.passedRestrictions;
    }

    void addPassedRestriction(PasswordRestriction pr) {
        this.passedRestrictions.add(pr);
    }

    public void negative(int i) {
        this.negative += i;
    }

    void positive(int i) {
        this.positive += i;
    }

    void addFailedRestriction(PasswordRestriction pr) {
        this.failedRestrictions.add(pr);
    }

    void calculateStrength() {
        float f = (float)this.negative / (float)this.positive;
        this.strength = f <= 0.03f ? PasswordStrength.EXCEPTIONAL : (f <= 0.1f ? PasswordStrength.VERY_STRONG : (f <= 0.15f ? PasswordStrength.STRONG : (f <= 0.5f ? PasswordStrength.MEDIUM : (f <= 0.7f ? PasswordStrength.MODERATE : (f <= 0.9f ? PasswordStrength.WEAK : PasswordStrength.VERY_WEAK)))));
    }
}

