/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ConfirmationChoice;
import org.jboss.as.domain.management.security.state.PromptNewUserState;
import org.jboss.as.domain.management.security.state.PromptRealmState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class ValidateRealmState
implements State {
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public ValidateRealmState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        String enteredRealm;
        String expectedRealm = this.stateValues.isManagement() ? "ManagementRealm" : "ApplicationRealm";
        if (!expectedRealm.equals(enteredRealm = this.stateValues.getRealm())) {
            String message = DomainManagementMessages.MESSAGES.alternativeRealm(expectedRealm);
            String prompt = DomainManagementMessages.MESSAGES.realmConfirmation(enteredRealm) + " " + DomainManagementMessages.MESSAGES.yes() + "/" + DomainManagementMessages.MESSAGES.no() + "?";
            return new ConfirmationChoice(this.theConsole, message, prompt, (State)new PromptNewUserState(this.theConsole, this.stateValues), (State)new PromptRealmState(this.theConsole, this.stateValues));
        }
        return new PromptNewUserState(this.theConsole, this.stateValues);
    }
}

