/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Locale;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.ConfigurableAuthorizer;
import org.jboss.as.controller.access.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.SimpleConfigurableAuthorizer;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.dmr.ModelNode;

class AccessAuthorizationProviderWriteAttributeHander
extends AbstractWriteAttributeHandler<Void> {
    private final DelegatingConfigurableAuthorizer configurableAuthorizer;
    private final RoleMapper rbacRoleMapper;

    AccessAuthorizationProviderWriteAttributeHander(DelegatingConfigurableAuthorizer configurableAuthorizer, RoleMapper rbacRoleMapper) {
        super(new AttributeDefinition[]{AccessAuthorizationResourceDefinition.PROVIDER});
        this.configurableAuthorizer = configurableAuthorizer;
        this.rbacRoleMapper = rbacRoleMapper;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        AccessAuthorizationResourceDefinition.Provider provider = AccessAuthorizationResourceDefinition.Provider.valueOf(newValue.asString().toUpperCase(Locale.ENGLISH));
        if (provider == AccessAuthorizationResourceDefinition.Provider.RBAC) {
            RbacSanityCheckOperation.registerOperation(context);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        if (!resolvedValue.equals(currentValue)) {
            if (!context.isBooting()) {
                return true;
            }
            this.updateAuthorizer(resolvedValue);
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        this.updateAuthorizer(valueToRestore);
    }

    private void updateAuthorizer(ModelNode value) {
        String providerName = value.asString().toUpperCase(Locale.ENGLISH);
        AccessAuthorizationResourceDefinition.Provider provider = AccessAuthorizationResourceDefinition.Provider.valueOf(providerName);
        ConfigurableAuthorizer delegate = provider == AccessAuthorizationResourceDefinition.Provider.SIMPLE ? this.getSimpleAuthorizer() : this.getRoleBasedAuthorizer();
        this.configurableAuthorizer.setDelegate(delegate);
    }

    private ConfigurableAuthorizer getSimpleAuthorizer() {
        return new SimpleConfigurableAuthorizer();
    }

    private ConfigurableAuthorizer getRoleBasedAuthorizer() {
        return new SimpleConfigurableAuthorizer(this.rbacRoleMapper);
    }
}

