/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.constraint.AbstractSensitivity;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.ApplicationTypeConstraint;
import org.jboss.as.controller.access.constraint.SensitiveTargetConstraint;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.constraint.VaultExpressionSensitivityConfig;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.as.domain.management.access.ApplicationClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;

public class AccessConstraintResources {
    public static final PathElement APPLICATION_PATH_ELEMENT = PathElement.pathElement((String)"constraint", (String)"application-classification");
    public static final Resource APPLICATION_RESOURCE = new ApplicationClassificationResource();
    public static final PathElement SENSITIVITY_PATH_ELEMENT = PathElement.pathElement((String)"constraint", (String)"sensitivity-classification");
    public static final Resource SENSITIVITY_RESOURCE = new SensitivityClassificationResource();
    public static final PathElement VAULT_PATH_ELEMENT = PathElement.pathElement((String)"constraint", (String)"vault-expression");
    public static final Resource VAULT_RESOURCE = SensitivityResourceDefinition.createResource((AbstractSensitivity)VaultExpressionSensitivityConfig.INSTANCE, VAULT_PATH_ELEMENT);
    private static volatile Map<String, Map<String, SensitivityClassification>> classifications;
    private static volatile Map<String, Map<String, ApplicationTypeConfig>> applicationTypes;

    private static Map<String, Map<String, SensitivityClassification>> getSensitivityClassifications() {
        Collection current = SensitiveTargetConstraint.FACTORY.getSensitivities();
        if (classifications == null || classifications.size() != current.size()) {
            TreeMap<String, Map<String, SensitivityClassification>> classificationsMap = new TreeMap<String, Map<String, SensitivityClassification>>();
            for (SensitivityClassification classification : current) {
                String type = classification.isCore() ? "core" : classification.getSubsystem();
                TreeMap<String, SensitivityClassification> byName = (TreeMap<String, SensitivityClassification>)classificationsMap.get(type);
                if (byName == null) {
                    byName = new TreeMap<String, SensitivityClassification>();
                    classificationsMap.put(type, byName);
                }
                byName.put(classification.getName(), classification);
            }
            classifications = classificationsMap;
        }
        return classifications;
    }

    private static Map<String, Map<String, ApplicationTypeConfig>> getApplicationClassifications() {
        Collection current = ApplicationTypeConstraint.FACTORY.getApplicationTypeConfigs();
        if (applicationTypes == null || applicationTypes.size() != current.size()) {
            TreeMap<String, Map<String, ApplicationTypeConfig>> classificationsMap = new TreeMap<String, Map<String, ApplicationTypeConfig>>();
            for (ApplicationTypeConfig classification : current) {
                String type = classification.isCore() ? "core" : classification.getSubsystem();
                TreeMap<String, ApplicationTypeConfig> byName = (TreeMap<String, ApplicationTypeConfig>)classificationsMap.get(type);
                if (byName == null) {
                    byName = new TreeMap<String, ApplicationTypeConfig>();
                    classificationsMap.put(type, byName);
                }
                byName.put(classification.getName(), classification);
            }
            applicationTypes = classificationsMap;
        }
        return applicationTypes;
    }

    private static class SensitivityClassificationResource
    extends AbstractClassificationResource {
        private static final Set<String> CHILD_TYPES = Collections.singleton("type");

        private SensitivityClassificationResource() {
            super(SENSITIVITY_PATH_ELEMENT);
        }

        public Set<String> getChildTypes() {
            return CHILD_TYPES;
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            Map classifications;
            Map byName;
            if ("type".equals(type) && (byName = (Map)(classifications = AccessConstraintResources.getSensitivityClassifications()).get(name)) != null) {
                return SensitivityClassificationTypeResourceDefinition.createResource(byName, type, name);
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if ("type".equals(type)) {
                Map classifications = AccessConstraintResources.getSensitivityClassifications();
                return classifications.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if ("type".equals(childType)) {
                Map classifications = AccessConstraintResources.getSensitivityClassifications();
                HashSet<Resource.ResourceEntry> children = new HashSet<Resource.ResourceEntry>();
                for (Map.Entry entry : classifications.entrySet()) {
                    children.add(SensitivityClassificationTypeResourceDefinition.createResource((Map)entry.getValue(), childType, (String)entry.getKey()));
                }
                return children;
            }
            return Collections.emptySet();
        }
    }

    private static class ApplicationClassificationResource
    extends AbstractClassificationResource {
        private static final Set<String> CHILD_TYPES = Collections.singleton("type");

        private ApplicationClassificationResource() {
            super(APPLICATION_PATH_ELEMENT);
        }

        public Set<String> getChildTypes() {
            return CHILD_TYPES;
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            Map applicationTypes;
            Map byName;
            if ("type".equals(type) && (byName = (Map)(applicationTypes = AccessConstraintResources.getApplicationClassifications()).get(name)) != null) {
                return ApplicationClassificationTypeResourceDefinition.createResource(byName, type, name);
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if ("type".equals(type)) {
                Map configs = AccessConstraintResources.getApplicationClassifications();
                return configs.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if ("type".equals(childType)) {
                Map applicationTypes = AccessConstraintResources.getApplicationClassifications();
                HashSet<Resource.ResourceEntry> children = new HashSet<Resource.ResourceEntry>();
                for (Map.Entry entry : applicationTypes.entrySet()) {
                    children.add(ApplicationClassificationTypeResourceDefinition.createResource((Map)entry.getValue(), childType, (String)entry.getKey()));
                }
                return children;
            }
            return Collections.emptySet();
        }
    }
}

