/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.access.ConfigurableAuthorizer;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.constraint.ServerGroupEffectConstraint;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class ServerGroupScopedRoleAdd
extends AbstractAddStepHandler {
    private final Map<String, ServerGroupEffectConstraint> constraintMap;
    private final ConfigurableAuthorizer authorizer;

    ServerGroupScopedRoleAdd(Map<String, ServerGroupEffectConstraint> constraintMap, ConfigurableAuthorizer authorizer) {
        super(new AttributeDefinition[]{ServerGroupScopedRoleResourceDefinition.BASE_ROLE, ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS});
        this.constraintMap = constraintMap;
        this.authorizer = authorizer;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String baseRole = ServerGroupScopedRoleResourceDefinition.BASE_ROLE.resolveModelAttribute(context, model).asString();
        List nodeList = ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS.resolveModelAttribute(context, model).asList();
        ServerGroupScopedRoleAdd.addScopedRole(roleName, baseRole, nodeList, this.authorizer, this.constraintMap);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.authorizer.removeScopedRole(roleName);
        this.constraintMap.remove(roleName);
    }

    static void addScopedRole(String roleName, String baseRole, List<ModelNode> serverGroupNodes, ConfigurableAuthorizer authorizer, Map<String, ServerGroupEffectConstraint> constraintMap) {
        ArrayList<String> serverGroups = new ArrayList<String>();
        for (ModelNode group : serverGroupNodes) {
            serverGroups.add(group.asString());
        }
        ServerGroupEffectConstraint constraint = new ServerGroupEffectConstraint(serverGroups);
        authorizer.addScopedRole(roleName, baseRole, (ScopingConstraint)constraint);
        constraintMap.put(roleName, constraint);
    }
}

