/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.audit.HandlerUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AuditLogHandlerResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition FORMATTER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("formatter", ModelType.STRING).setAllowNull(false).setMinSize(1)).build();
    public static final SimpleAttributeDefinition MAX_FAILURE_COUNT = new SimpleAttributeDefinitionBuilder("max-failure-count", ModelType.INT).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).setValidator((ParameterValidator)new IntRangeValidator(0, true, true)).build();
    public static final SimpleAttributeDefinition FAILURE_COUNT = new SimpleAttributeDefinitionBuilder("failure-count", ModelType.INT).setAllowNull(false).setStorageRuntime().build();
    public static final SimpleAttributeDefinition DISABLED_DUE_TO_FAILURE = new SimpleAttributeDefinitionBuilder("disabled-due-to-failure", ModelType.BOOLEAN).setAllowNull(false).setStorageRuntime().build();
    private static final AttributeDefinition[] RUNTIME_ATTRIBUTES = new AttributeDefinition[]{FAILURE_COUNT, DISABLED_DUE_TO_FAILURE};
    protected final ManagedAuditLogger auditLogger;
    protected final PathManagerService pathManager;

    AuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager, PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(pathElement, descriptionResolver, addHandler, removeHandler);
        this.auditLogger = auditLogger;
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : RUNTIME_ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(def, (OperationStepHandler)new HandlerRuntimeAttributeHandler(this.auditLogger));
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("recycle", this.getResourceDescriptionResolver()).setRuntimeOnly().build(), (OperationStepHandler)new HandlerRecycleHandler(this.auditLogger));
    }

    static abstract class HandlerWriteAttributeHandler
    extends AbstractWriteAttributeHandler<Void> {
        final ManagedAuditLogger auditLogger;
        final PathManagerService pathManager;

        public HandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
            super(attributeDefinitions);
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            if (attributeName.equals(FORMATTER.getName())) {
                String formatterName = newValue.asString();
                if (!HandlerUtil.lookForFormatter(context, PathAddress.pathAddress((ModelNode)operation.require("address")), formatterName)) {
                    throw DomainManagementMessages.MESSAGES.noFormatterCalled(formatterName);
                }
            }
        }

        boolean handleApplyAttributeRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if (attributeName.equals(FORMATTER.getName())) {
                this.auditLogger.updateHandlerFormatter(Util.getNameFromAddress((ModelNode)operation.require("address")), resolvedValue.asString());
                return true;
            }
            if (attributeName.equals(MAX_FAILURE_COUNT.getName())) {
                this.auditLogger.updateHandlerMaxFailureCount(Util.getNameFromAddress((ModelNode)operation.require("address")), resolvedValue.asInt());
                return true;
            }
            return false;
        }

        boolean handlerRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (attributeName.equals(FORMATTER.getName())) {
                this.auditLogger.updateHandlerFormatter(Util.getNameFromAddress((ModelNode)operation.require("address")), valueToRestore.asString());
                return true;
            }
            if (attributeName.equals(MAX_FAILURE_COUNT.getName())) {
                this.auditLogger.updateHandlerMaxFailureCount(Util.getNameFromAddress((ModelNode)operation.require("address")), valueToRestore.asInt());
            }
            return false;
        }
    }

    static class HandlerRemoveHandler
    extends AbstractRemoveStepHandler {
        private final ManagedAuditLogger auditLogger;

        public HandlerRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().removeHandler(Util.getNameFromAddress((ModelNode)operation.require("address")));
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    private static class HandlerRecycleHandler
    extends AbstractRuntimeOnlyHandler {
        private final ManagedAuditLogger auditLogger;

        public HandlerRecycleHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.auditLogger.recycleHandler(Util.getNameFromAddress((ModelNode)operation.require("address")));
            context.stepCompleted();
        }
    }

    private static class HandlerRuntimeAttributeHandler
    extends AbstractRuntimeOnlyHandler {
        private final ManagedAuditLogger auditLogger;

        public HandlerRuntimeAttributeHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attr = operation.require("name").asString();
            String handlerName = Util.getNameFromAddress((ModelNode)operation.require("address"));
            if (attr.equals(FAILURE_COUNT.getName())) {
                context.getResult().set(this.auditLogger.getHandlerFailureCount(handlerName));
            } else if (attr.equals(DISABLED_DUE_TO_FAILURE.getName())) {
                context.getResult().set(this.auditLogger.getHandlerDisabledDueToFailure(handlerName));
            }
            context.stepCompleted();
        }
    }
}

