/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.wildfly.extension.microprofile.health._private.MicroProfileHealthLogger;

public class HealthReporter {
    public static final String DOWN = "DOWN";
    public static final String UP = "UP";
    private Map<HealthCheck, ClassLoader> healthChecks = new HashMap<HealthCheck, ClassLoader>();
    private Map<HealthCheck, ClassLoader> livenessChecks = new HashMap<HealthCheck, ClassLoader>();
    private Map<HealthCheck, ClassLoader> readinessChecks = new HashMap<HealthCheck, ClassLoader>();
    private final String emptyLivenessChecksStatus;
    private final String emptyReadinessChecksStatus;

    public HealthReporter(String emptyLivenessChecksStatus, String emptyReadinessChecksStatus) {
        this.emptyLivenessChecksStatus = emptyLivenessChecksStatus;
        this.emptyReadinessChecksStatus = emptyReadinessChecksStatus;
    }

    public SmallRyeHealth getHealth() {
        String emptyChecksStatus = DOWN.equals(this.emptyLivenessChecksStatus) || DOWN.equals(this.emptyReadinessChecksStatus) ? DOWN : UP;
        return this.getHealth(emptyChecksStatus, this.healthChecks, this.livenessChecks, this.readinessChecks);
    }

    public SmallRyeHealth getLiveness() {
        return this.getHealth(this.emptyLivenessChecksStatus, this.livenessChecks);
    }

    public SmallRyeHealth getReadiness() {
        return this.getHealth(this.emptyReadinessChecksStatus, this.readinessChecks);
    }

    @SafeVarargs
    private final SmallRyeHealth getHealth(String emptyChecksStatus, Map<HealthCheck, ClassLoader> ... checks) {
        JsonArrayBuilder results = Json.createArrayBuilder();
        HealthCheckResponse.State status = HealthCheckResponse.State.UP;
        if (checks != null) {
            for (Map<HealthCheck, ClassLoader> entry : checks) {
                status = this.processChecks(entry, results, status);
            }
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonArray checkResults = results.build();
        builder.add("status", checkResults.isEmpty() ? emptyChecksStatus : status.toString());
        builder.add("checks", (JsonValue)checkResults);
        return new SmallRyeHealth(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse.State processChecks(Map<HealthCheck, ClassLoader> checks, JsonArrayBuilder results, HealthCheckResponse.State status) {
        if (checks != null) {
            for (Map.Entry<HealthCheck, ClassLoader> entry : checks.entrySet()) {
                ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(entry.getValue());
                    status = this.fillCheck(entry.getKey(), results, status);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldTCCL);
                }
            }
        }
        return status;
    }

    private HealthCheckResponse.State fillCheck(HealthCheck check, JsonArrayBuilder results, HealthCheckResponse.State globalOutcome) {
        String status;
        JsonObject each = this.jsonObject(check);
        results.add((JsonValue)each);
        if (globalOutcome == HealthCheckResponse.State.UP && (status = each.getString("status")).equals(DOWN)) {
            return HealthCheckResponse.State.DOWN;
        }
        return globalOutcome;
    }

    private JsonObject jsonObject(HealthCheck check) {
        try {
            return this.jsonObject(check.call());
        }
        catch (RuntimeException e) {
            MicroProfileHealthLogger.LOGGER.error("Error processing Health Checks", e);
            HealthCheckResponseBuilder response = HealthCheckResponse.named((String)check.getClass().getName()).down();
            return this.jsonObject(response.build());
        }
    }

    private JsonObject jsonObject(HealthCheckResponse response) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", response.getName());
        builder.add("status", response.getState().toString());
        response.getData().ifPresent(d -> {
            JsonObjectBuilder data = Json.createObjectBuilder();
            for (Map.Entry entry : d.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    data.add((String)entry.getKey(), ((Long)value).longValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
            }
            builder.add("data", (JsonValue)data.build());
        });
        return builder.build();
    }

    public void addHealthCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.healthChecks.put(check, moduleClassLoader);
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.healthChecks.remove(check);
    }

    public void addReadinessCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.readinessChecks.put(check, moduleClassLoader);
        }
    }

    public void removeReadinessCheck(HealthCheck check) {
        this.readinessChecks.remove(check);
    }

    public void addLivenessCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.livenessChecks.put(check, moduleClassLoader);
        }
    }

    public void removeLivenessCheck(HealthCheck check) {
        this.livenessChecks.remove(check);
    }
}

