/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.AbstractModuleTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class ModuleRemoveTask
extends AbstractModuleTask {
    ModuleRemoveTask(PatchingTaskDescription description) {
        super(description);
    }

    @Override
    protected boolean failOnContentMismatch(PatchingTaskContext context) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        File targetDir = context.getTargetFile(this.contentItem);
        if (!targetDir.mkdirs()) {
            throw PatchMessages.MESSAGES.cannotCreateDirectory(targetDir.getAbsolutePath());
        }
        File moduleXml = new File(targetDir, "module.xml");
        ByteArrayInputStream is = new ByteArrayInputStream(ModuleRemoveTask.getFileContent((ModuleItem)this.contentItem));
        try {
            byte[] byArray = IoUtils.copy(is, moduleXml);
            return byArray;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    @Override
    protected ContentModification getOriginalModification(byte[] targetHash, byte[] itemHash) {
        ModuleItem original = (ModuleItem)this.getContentItem();
        ModuleItem item = new ModuleItem(original.getName(), original.getSlot(), targetHash);
        return new ContentModification(item, this.description.getModification().getTargetHash(), ModificationType.MODIFY);
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        ModuleItem item = ModuleRemoveTask.createContentItem((ModuleItem)this.contentItem, itemHash);
        return new ContentModification(item, targetHash, ModificationType.MODIFY);
    }

    static byte[] getFileContent(ModuleItem item) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("<?xml version='1.0' encoding='UTF-8'?>\n<module-absent xmlns=\"urn:jboss:module:1.2\"");
        builder.append(" name=\"").append(item.getName()).append("\"");
        builder.append(" slot=\"").append(item.getSlot()).append("\"");
        builder.append(" />\n");
        return builder.toString().getBytes(Charset.forName("UTF-8"));
    }
}

