/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.patching.validation.Artifact;
import org.jboss.as.patching.validation.Context;

public abstract class AbstractArtifact<P extends Artifact.State, S extends Artifact.State>
implements Artifact<P, S> {
    protected Artifact<? extends Artifact.State, P> parent;
    protected List<Artifact<S, ? extends Artifact.State>> artifacts = Collections.emptyList();

    public S getState(Context ctx) {
        return (S)this.getState2(this, ctx);
    }

    protected <A extends Artifact.State, B extends Artifact.State, C extends Artifact.State> A getState2(AbstractArtifact<B, C> artifact, Context ctx) {
        P state = null;
        if (artifact.parent != null) {
            A parentState = this.getState2((AbstractArtifact)artifact.parent, ctx);
            return (A)artifact.getState(parentState, ctx);
        }
        return (A)artifact.getState(state, ctx);
    }

    void addArtifact(Artifact<S, ? extends Artifact.State> a) {
        if (a == null) {
            throw new IllegalArgumentException("Artifact is null");
        }
        switch (this.artifacts.size()) {
            case 0: {
                this.artifacts = Collections.singletonList(a);
                break;
            }
            case 1: {
                Artifact<S, ? extends Artifact.State> first = this.artifacts.get(0);
                this.artifacts = new ArrayList<Artifact<S, ? extends Artifact.State>>();
                this.artifacts.add(first);
            }
            default: {
                this.artifacts.add(a);
            }
        }
    }

    @Override
    public Collection<Artifact<S, ? extends Artifact.State>> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public S validate(P parent, Context ctx) {
        S state = this.getInitialState(parent, ctx);
        if (state != null) {
            this.validateForState(ctx, state);
        }
        return state;
    }

    protected void validateForState(Context ctx, S state) {
        state.validate(ctx);
        for (Artifact<S, Artifact.State> a : this.getArtifacts()) {
            a.validate(state, ctx);
        }
    }

    protected abstract S getInitialState(P var1, Context var2);

    @Override
    public S getState(P parent, Context ctx) {
        return this.validate(parent, ctx);
    }
}

