/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import org.wildfly.extension.undertow.deployment.ServletResourceManager;

public class ServletResource
implements Resource,
RangeAwareResource {
    private final ServletResourceManager resourceManager;
    private final Resource underlying;

    public ServletResource(ServletResourceManager resourceManager, Resource underlying) {
        this.resourceManager = resourceManager;
        this.underlying = underlying;
    }

    public String getPath() {
        return this.underlying.getPath();
    }

    public Date getLastModified() {
        return this.underlying.getLastModified();
    }

    public String getLastModifiedString() {
        return this.underlying.getLastModifiedString();
    }

    public ETag getETag() {
        return this.underlying.getETag();
    }

    public String getName() {
        return this.underlying.getName();
    }

    public boolean isDirectory() {
        return this.underlying.isDirectory();
    }

    public List<Resource> list() {
        return this.resourceManager.list(this.getPath());
    }

    public String getContentType(MimeMappings mimeMappings) {
        return this.underlying.getContentType(mimeMappings);
    }

    public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
        this.underlying.serve(sender, exchange, completionCallback);
    }

    public Long getContentLength() {
        return this.underlying.getContentLength();
    }

    public String getCacheKey() {
        return this.underlying.getCacheKey();
    }

    public File getFile() {
        return this.underlying.getFile();
    }

    public File getResourceManagerRoot() {
        return this.underlying.getResourceManagerRoot();
    }

    public URL getUrl() {
        return this.underlying.getUrl();
    }

    public Path getResourceManagerRootPath() {
        return this.getResourceManagerRoot().toPath();
    }

    public Path getFilePath() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().toPath();
    }

    public void serveRange(Sender sender, HttpServerExchange exchange, long start, long end, IoCallback completionCallback) {
        ((RangeAwareResource)this.underlying).serveRange(sender, exchange, start, end, completionCallback);
    }

    public boolean isRangeSupported() {
        if (this.underlying instanceof RangeAwareResource) {
            return ((RangeAwareResource)this.underlying).isRangeSupported();
        }
        return false;
    }
}

