/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class TldParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String TLD = ".tld";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes";
    private static final String LIB = "lib";
    private static final String IMPLICIT_TLD = "implicit.tld";
    private static final String RESOURCES = "resources";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        JBossWebMetaData mergedMd;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null || warMetaData.getMergedJBossWebMetaData() == null) {
            return;
        }
        TldsMetaData tldsMetaData = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        if (tldsMetaData == null) {
            tldsMetaData = new TldsMetaData();
            deploymentUnit.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
        }
        HashMap<String, TldMetaData> tlds = new HashMap<String, TldMetaData>();
        tldsMetaData.setTlds(tlds);
        ArrayList<TldMetaData> uniqueTlds = new ArrayList<TldMetaData>();
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        ArrayList<VirtualFile> testRoots = new ArrayList<VirtualFile>();
        testRoots.add(deploymentRoot);
        testRoots.add(deploymentRoot.getChild(WEB_INF));
        testRoots.add(deploymentRoot.getChild(META_INF));
        for (Object root : deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) {
            testRoots.add(root.getRoot());
            testRoots.add(root.getRoot().getChild(META_INF));
            testRoots.add(root.getRoot().getChild(META_INF).getChild(RESOURCES));
        }
        JspConfigMetaData merged = warMetaData.getMergedJBossWebMetaData().getJspConfig();
        if (merged != null && merged.getTaglibs() != null) {
            for (TaglibMetaData tld : merged.getTaglibs()) {
                boolean found = false;
                for (VirtualFile root : testRoots) {
                    VirtualFile child = root.getChild(tld.getTaglibLocation());
                    if (!child.exists()) continue;
                    if (this.isTldFile(child)) {
                        TldMetaData value = this.processTld(deploymentRoot, child, tlds, uniqueTlds);
                        if (!tlds.containsKey(tld.getTaglibUri())) {
                            tlds.put(tld.getTaglibUri(), value);
                        }
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                UndertowLogger.ROOT_LOGGER.tldNotFound(tld.getTaglibLocation());
            }
        }
        List resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile webFragment;
            if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(webFragment = resourceRoot.getRoot().getChild(META_INF)).exists() || !webFragment.isDirectory()) continue;
            this.processTlds(deploymentRoot, webFragment.getChildren(), tlds, uniqueTlds);
        }
        VirtualFile webInf = deploymentRoot.getChild(WEB_INF);
        if (webInf.exists() && webInf.isDirectory()) {
            for (VirtualFile file : webInf.getChildren()) {
                if (this.isTldFile(file)) {
                    this.processTld(deploymentRoot, file, tlds, uniqueTlds);
                    continue;
                }
                if (!file.isDirectory() || CLASSES.equals(file.getName()) || LIB.equals(file.getName())) continue;
                this.processTlds(deploymentRoot, file.getChildren(), tlds, uniqueTlds);
            }
        }
        if ((mergedMd = warMetaData.getMergedJBossWebMetaData()).getListeners() == null) {
            mergedMd.setListeners(new ArrayList());
        }
        ArrayList<TldMetaData> allTlds = new ArrayList<TldMetaData>(uniqueTlds);
        allTlds.addAll(tldsMetaData.getSharedTlds(deploymentUnit));
        for (TldMetaData tld : allTlds) {
            if (tld.getListeners() == null) continue;
            for (ListenerMetaData l : tld.getListeners()) {
                mergedMd.getListeners().add(l);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean isTldFile(VirtualFile file) {
        return file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(TLD);
    }

    private TldMetaData processTld(VirtualFile root, VirtualFile file, Map<String, TldMetaData> tlds, List<TldMetaData> uniqueTlds) throws DeploymentUnitProcessingException {
        String pathNameRelativeToRoot;
        try {
            pathNameRelativeToRoot = file.getPathNameRelativeTo(root);
        }
        catch (IllegalArgumentException e) {
            throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.tldFileNotContainedInRoot(file.getPathName(), root.getPathName()), (Throwable)e);
        }
        TldMetaData value = this.parseTLD(file);
        String key = "/" + pathNameRelativeToRoot;
        uniqueTlds.add(value);
        if (!tlds.containsKey(key)) {
            tlds.put(key, value);
        }
        return value;
    }

    private void processTlds(VirtualFile root, List<VirtualFile> files, Map<String, TldMetaData> tlds, List<TldMetaData> uniqueTlds) throws DeploymentUnitProcessingException {
        for (VirtualFile file : files) {
            if (this.isTldFile(file)) {
                this.processTld(root, file, tlds, uniqueTlds);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.processTlds(root, file.getChildren(), tlds, uniqueTlds);
        }
    }

    private TldMetaData parseTLD(VirtualFile tld) throws DeploymentUnitProcessingException {
        if (IMPLICIT_TLD.equals(tld.getName())) {
            return new TldMetaData();
        }
        InputStream is = null;
        try {
            is = tld.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToParseXMLDescriptor(tld.toString(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber()), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToParseXMLDescriptor(tld.toString()), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

