/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.security.NotAuthorisedException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractFileSource
implements FileSource {
    protected final File rootDirectory;

    protected AbstractFileSource(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    protected abstract boolean readOnly();

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        this.assertFilePathIsUnderRoot(name);
        return new BinaryFile(new File(this.rootDirectory, name).toURI());
    }

    @Override
    public TextFile getTextFileNamed(String name) {
        this.assertFilePathIsUnderRoot(name);
        return new TextFile(new File(this.rootDirectory, name).toURI());
    }

    @Override
    public void createIfNecessary() {
        this.assertWritable();
        if (this.rootDirectory.exists() && this.rootDirectory.isFile()) {
            throw new IllegalStateException(this.rootDirectory + " already exists and is a file");
        }
        if (!this.rootDirectory.exists()) {
            this.rootDirectory.mkdirs();
        }
    }

    @Override
    public String getPath() {
        return this.rootDirectory.getPath();
    }

    @Override
    public URI getUri() {
        return this.rootDirectory.toURI();
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        this.assertExistsAndIsDirectory();
        ArrayList<File> fileList = new ArrayList<File>();
        this.recursivelyAddFilesToList(this.rootDirectory, fileList);
        return this.toTextFileList(fileList);
    }

    private void recursivelyAddFilesToList(File root, List<File> fileList) {
        File[] files;
        for (File file : files = Optional.ofNullable(root.listFiles()).orElse(new File[0])) {
            if (file.isDirectory()) {
                this.recursivelyAddFilesToList(file, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    private List<TextFile> toTextFileList(List<File> fileList) {
        return fileList.stream().map(input -> new TextFile(input.toURI())).collect(Collectors.toList());
    }

    @Override
    public void writeTextFile(String name, String contents) {
        this.writeTextFileAndTranslateExceptions(contents, this.writableFileFor(name));
    }

    @Override
    public void writeBinaryFile(String name, byte[] contents) {
        this.writeBinaryFileAndTranslateExceptions(contents, this.writableFileFor(name));
    }

    @Override
    public void deleteFile(String name) {
        this.writableFileFor(name).delete();
    }

    @Override
    public boolean exists() {
        return this.rootDirectory.exists();
    }

    private File writableFileFor(String name) {
        this.assertExistsAndIsDirectory();
        this.assertFilePathIsUnderRoot(name);
        this.assertWritable();
        File filePath = new File(name);
        if (filePath.isAbsolute()) {
            return filePath;
        }
        return new File(this.rootDirectory, name);
    }

    private void assertExistsAndIsDirectory() {
        if (this.rootDirectory.exists() && !this.rootDirectory.isDirectory()) {
            throw new RuntimeException(this.rootDirectory + " is not a directory");
        }
        if (!this.rootDirectory.exists()) {
            throw new RuntimeException(this.rootDirectory + " does not exist");
        }
    }

    private void assertWritable() {
        if (this.readOnly()) {
            throw new UnsupportedOperationException("Can't write to read only file sources");
        }
    }

    private void assertFilePathIsUnderRoot(String path) {
        try {
            String filePath;
            String rootPath = this.rootDirectory.getCanonicalPath();
            File file = new File(path);
            String string = filePath = file.isAbsolute() ? new File(path).getCanonicalPath() : new File(this.rootDirectory, path).getCanonicalPath();
            if (!Paths.get(filePath, new String[0]).normalize().startsWith(rootPath)) {
                throw new NotAuthorisedException("Access to file " + path + " is not permitted. An absolute path from the filesystem root might be specified");
            }
        }
        catch (IOException ioe) {
            throw new NotAuthorisedException("File " + path + " cannot be accessed", ioe);
        }
    }

    private void ensureDirectoryExists(File toFile) throws IOException {
        Path toPath = toFile.toPath();
        if (!Files.exists(toPath, new LinkOption[0])) {
            Path toParentPath = toPath.getParent();
            Files.createDirectories(toParentPath, new FileAttribute[0]);
        }
    }

    private void writeTextFileAndTranslateExceptions(String contents, File toFile) {
        try {
            this.ensureDirectoryExists(toFile);
            Files.write(toFile.toPath(), contents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void writeBinaryFileAndTranslateExceptions(byte[] contents, File toFile) {
        try {
            this.ensureDirectoryExists(toFile);
            Files.write(toFile.toPath(), contents, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Predicate<BinaryFile> byFileExtension(String extension) {
        return input -> input.name().endsWith("." + extension);
    }
}

