/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal.antlr;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import wiremock.com.github.jknack.handlebars.internal.antlr.ANTLRErrorListener;
import wiremock.com.github.jknack.handlebars.internal.antlr.CharStream;
import wiremock.com.github.jknack.handlebars.internal.antlr.CommonTokenFactory;
import wiremock.com.github.jknack.handlebars.internal.antlr.IntStream;
import wiremock.com.github.jknack.handlebars.internal.antlr.LexerNoViableAltException;
import wiremock.com.github.jknack.handlebars.internal.antlr.RecognitionException;
import wiremock.com.github.jknack.handlebars.internal.antlr.Recognizer;
import wiremock.com.github.jknack.handlebars.internal.antlr.Token;
import wiremock.com.github.jknack.handlebars.internal.antlr.TokenFactory;
import wiremock.com.github.jknack.handlebars.internal.antlr.TokenSource;
import wiremock.com.github.jknack.handlebars.internal.antlr.atn.LexerATNSimulator;
import wiremock.com.github.jknack.handlebars.internal.antlr.misc.IntegerStack;
import wiremock.com.github.jknack.handlebars.internal.antlr.misc.Interval;
import wiremock.com.github.jknack.handlebars.internal.antlr.misc.Pair;

public abstract class Lexer
extends Recognizer<Integer, LexerATNSimulator>
implements TokenSource {
    public static final int DEFAULT_MODE = 0;
    public static final int MORE = -2;
    public static final int SKIP = -3;
    public static final int DEFAULT_TOKEN_CHANNEL = 0;
    public static final int HIDDEN = 1;
    public static final int MIN_CHAR_VALUE = 0;
    public static final int MAX_CHAR_VALUE = 0x10FFFF;
    public CharStream _input;
    protected Pair<TokenSource, CharStream> _tokenFactorySourcePair;
    protected TokenFactory<?> _factory = CommonTokenFactory.DEFAULT;
    public Token _token;
    public int _tokenStartCharIndex = -1;
    public int _tokenStartLine;
    public int _tokenStartCharPositionInLine;
    public boolean _hitEOF;
    public int _channel;
    public int _type;
    public final IntegerStack _modeStack = new IntegerStack();
    public int _mode = 0;
    public String _text;

    public Lexer() {
    }

    public Lexer(CharStream input) {
        this._input = input;
        this._tokenFactorySourcePair = new Pair<Lexer, CharStream>(this, input);
    }

    public void reset() {
        if (this._input != null) {
            this._input.seek(0);
        }
        this._token = null;
        this._type = 0;
        this._channel = 0;
        this._tokenStartCharIndex = -1;
        this._tokenStartCharPositionInLine = -1;
        this._tokenStartLine = -1;
        this._text = null;
        this._hitEOF = false;
        this._mode = 0;
        this._modeStack.clear();
        ((LexerATNSimulator)this.getInterpreter()).reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token nextToken() {
        if (this._input == null) {
            throw new IllegalStateException("nextToken requires a non-null input stream.");
        }
        int tokenStartMarker = this._input.mark();
        try {
            block6: while (true) {
                if (this._hitEOF) {
                    this.emitEOF();
                    Token token = this._token;
                    return token;
                }
                this._token = null;
                this._channel = 0;
                this._tokenStartCharIndex = this._input.index();
                this._tokenStartCharPositionInLine = ((LexerATNSimulator)this.getInterpreter()).getCharPositionInLine();
                this._tokenStartLine = ((LexerATNSimulator)this.getInterpreter()).getLine();
                this._text = null;
                do {
                    int ttype;
                    this._type = 0;
                    try {
                        ttype = ((LexerATNSimulator)this.getInterpreter()).match(this._input, this._mode);
                    }
                    catch (LexerNoViableAltException e) {
                        this.notifyListeners(e);
                        this.recover(e);
                        ttype = -3;
                    }
                    if (this._input.LA(1) == -1) {
                        this._hitEOF = true;
                    }
                    if (this._type == 0) {
                        this._type = ttype;
                    }
                    if (this._type == -3) continue block6;
                } while (this._type == -2);
                break;
            }
            if (this._token == null) {
                this.emit();
            }
            Token token = this._token;
            return token;
        }
        finally {
            this._input.release(tokenStartMarker);
        }
    }

    public void skip() {
        this._type = -3;
    }

    public void more() {
        this._type = -2;
    }

    public void mode(int m4) {
        this._mode = m4;
    }

    public void pushMode(int m4) {
        this._modeStack.push(this._mode);
        this.mode(m4);
    }

    public int popMode() {
        if (this._modeStack.isEmpty()) {
            throw new EmptyStackException();
        }
        this.mode(this._modeStack.pop());
        return this._mode;
    }

    @Override
    public void setTokenFactory(TokenFactory<?> factory) {
        this._factory = factory;
    }

    @Override
    public TokenFactory<? extends Token> getTokenFactory() {
        return this._factory;
    }

    @Override
    public void setInputStream(IntStream input) {
        this._input = null;
        this._tokenFactorySourcePair = new Pair<Lexer, CharStream>(this, this._input);
        this.reset();
        this._input = (CharStream)input;
        this._tokenFactorySourcePair = new Pair<Lexer, CharStream>(this, this._input);
    }

    @Override
    public String getSourceName() {
        return this._input.getSourceName();
    }

    @Override
    public CharStream getInputStream() {
        return this._input;
    }

    public void emit(Token token) {
        this._token = token;
    }

    public Token emit() {
        Object t2 = this._factory.create(this._tokenFactorySourcePair, this._type, this._text, this._channel, this._tokenStartCharIndex, this.getCharIndex() - 1, this._tokenStartLine, this._tokenStartCharPositionInLine);
        this.emit((Token)t2);
        return t2;
    }

    public Token emitEOF() {
        int cpos = this.getCharPositionInLine();
        int line = this.getLine();
        Object eof = this._factory.create(this._tokenFactorySourcePair, -1, null, 0, this._input.index(), this._input.index() - 1, line, cpos);
        this.emit((Token)eof);
        return eof;
    }

    @Override
    public int getLine() {
        return ((LexerATNSimulator)this.getInterpreter()).getLine();
    }

    @Override
    public int getCharPositionInLine() {
        return ((LexerATNSimulator)this.getInterpreter()).getCharPositionInLine();
    }

    public void setLine(int line) {
        ((LexerATNSimulator)this.getInterpreter()).setLine(line);
    }

    public void setCharPositionInLine(int charPositionInLine) {
        ((LexerATNSimulator)this.getInterpreter()).setCharPositionInLine(charPositionInLine);
    }

    public int getCharIndex() {
        return this._input.index();
    }

    public String getText() {
        if (this._text != null) {
            return this._text;
        }
        return ((LexerATNSimulator)this.getInterpreter()).getText(this._input);
    }

    public void setText(String text) {
        this._text = text;
    }

    public Token getToken() {
        return this._token;
    }

    public void setToken(Token _token) {
        this._token = _token;
    }

    public void setType(int ttype) {
        this._type = ttype;
    }

    public int getType() {
        return this._type;
    }

    public void setChannel(int channel) {
        this._channel = channel;
    }

    public int getChannel() {
        return this._channel;
    }

    public String[] getChannelNames() {
        return null;
    }

    public String[] getModeNames() {
        return null;
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return null;
    }

    public List<? extends Token> getAllTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token t2 = this.nextToken();
        while (t2.getType() != -1) {
            tokens.add(t2);
            t2 = this.nextToken();
        }
        return tokens;
    }

    public void recover(LexerNoViableAltException e) {
        if (this._input.LA(1) != -1) {
            ((LexerATNSimulator)this.getInterpreter()).consume(this._input);
        }
    }

    public void notifyListeners(LexerNoViableAltException e) {
        String text = this._input.getText(Interval.of(this._tokenStartCharIndex, this._input.index()));
        String msg = "token recognition error at: '" + this.getErrorDisplay(text) + "'";
        ANTLRErrorListener listener = this.getErrorListenerDispatch();
        listener.syntaxError(this, null, this._tokenStartLine, this._tokenStartCharPositionInLine, msg, e);
    }

    public String getErrorDisplay(String s2) {
        StringBuilder buf = new StringBuilder();
        for (char c : s2.toCharArray()) {
            buf.append(this.getErrorDisplay(c));
        }
        return buf.toString();
    }

    public String getErrorDisplay(int c) {
        String s2 = String.valueOf((char)c);
        switch (c) {
            case -1: {
                s2 = "<EOF>";
                break;
            }
            case 10: {
                s2 = "\\n";
                break;
            }
            case 9: {
                s2 = "\\t";
                break;
            }
            case 13: {
                s2 = "\\r";
            }
        }
        return s2;
    }

    public String getCharErrorDisplay(int c) {
        String s2 = this.getErrorDisplay(c);
        return "'" + s2 + "'";
    }

    public void recover(RecognitionException re) {
        this._input.consume();
    }
}

