/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.hash;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import wiremock.com.google.common.annotations.Beta;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.hash.ElementTypesAreNonnullByDefault;
import wiremock.com.google.common.hash.HashCode;
import wiremock.com.google.common.hash.HashFunction;
import wiremock.com.google.common.hash.Hasher;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

