/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.com.networknt.schema.serialization.JsonMapperFactory;

public class JsonNodeAnnotations {
    private final Map<JsonNodePath, List<JsonNodeAnnotation>> values = new LinkedHashMap<JsonNodePath, List<JsonNodeAnnotation>>();

    public Map<JsonNodePath, List<JsonNodeAnnotation>> asMap() {
        return this.values;
    }

    public void put(JsonNodeAnnotation annotation) {
        this.values.computeIfAbsent(annotation.getInstanceLocation(), k -> new ArrayList()).add(annotation);
    }

    public String toString() {
        return Formatter.format(this.values);
    }

    public static class Formatter {
        public static String format(Map<JsonNodePath, List<JsonNodeAnnotation>> annotations) {
            LinkedHashMap<String, Map> results = new LinkedHashMap<String, Map>();
            for (List<JsonNodeAnnotation> list : annotations.values()) {
                for (JsonNodeAnnotation annotation : list) {
                    String keyword = annotation.getKeyword();
                    String instancePath = annotation.getInstanceLocation().toString();
                    String evaluationPath = annotation.getEvaluationPath().toString();
                    Map values = results.computeIfAbsent(instancePath, key -> new LinkedHashMap()).computeIfAbsent(keyword, key -> new LinkedHashMap());
                    values.put(evaluationPath, annotation.getValue());
                }
            }
            try {
                return JsonMapperFactory.getInstance().writerWithDefaultPrettyPrinter().writeValueAsString(results);
            }
            catch (JsonProcessingException e) {
                return "";
            }
        }
    }
}

