/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.ssl;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Source;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;

public abstract class KeyStoreSource
implements Source<KeyStore> {
    protected final String keyStoreType;
    protected final char[] keyStorePassword;

    protected KeyStoreSource(String keyStoreType, char[] keyStorePassword) {
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore load() {
        InputStream instream = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(this.keyStoreType);
            instream = this.createInputStream();
            trustStore.load(instream, this.keyStorePassword);
            KeyStore keyStore = trustStore;
            return keyStore;
        }
        catch (Exception e) {
            KeyStore keyStore = Exceptions.throwUnchecked(e, KeyStore.class);
            return keyStore;
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException ioe) {
                    Exceptions.throwUnchecked(ioe);
                }
            }
        }
    }

    protected abstract InputStream createInputStream();

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePassword() {
        return new String(this.keyStorePassword);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreSource that = (KeyStoreSource)o;
        return this.keyStoreType.equals(that.keyStoreType) && Arrays.equals(this.keyStorePassword, that.keyStorePassword);
    }

    public int hashCode() {
        int result = Objects.hash(this.keyStoreType);
        result = 31 * result + Arrays.hashCode(this.keyStorePassword);
        return result;
    }
}

