/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.utils;

import java.net.IDN;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.BitSet;
import java.util.function.BiPredicate;
import wiremock.com.networknt.schema.utils.UCDLoader;
import wiremock.com.networknt.schema.utils.UnicodeDatabase;

public class RFC5892 {
    private static final String ACE_PREFIX = "xn--";
    private static final int ACE_PREFIX_LENGTH = "xn--".length();
    private static final int GREEK_LOWER_NUMERAL_SIGN = 885;
    private static final int HEBREW_GERESH = 1523;
    private static final int HEBREW_GERSHAYIM = 1524;
    private static final int KATAKANA_MIDDLE_DOT = 12539;
    private static final int MIDDLE_DOT = 183;
    private static final int VIRAMA = 2381;
    private static final int ZERO_WIDTH_JOINER = 8205;
    private static final int ZERO_WIDTH_NON_JOINER = 8204;
    private static final BitSet CONTEXTJ = new BitSet(0x110000);
    private static final BitSet CONTEXTO = new BitSet(0x110000);
    private static final BitSet DISALLOWED = new BitSet(0x110000);
    private static final BitSet UNASSIGNED = new BitSet(0x110000);
    private static BiPredicate<String, Integer> RULE_ARABIC_INDIC_DIGITS_RULE = RFC5892::testArabicIndicDigit;
    private static BiPredicate<String, Integer> RULE_EXTENDED_ARABIC_INDIC_DIGITS_RULE = RFC5892::testExtendedArabicIndicDigit;
    private static BiPredicate<String, Integer> RULE_GREEK_LOWER_NUMERAL_SIGN = RFC5892::testGreekLowerNumeralSign;
    private static BiPredicate<String, Integer> RULE_HEBREW_GERESH_GERSHAYIM = RFC5892::testHebrewPuncuation;
    private static BiPredicate<String, Integer> RULE_KATAKANA_MIDDLE_DOT = RFC5892::testKatakanaMiddleDot;
    private static BiPredicate<String, Integer> RULE_MIDDLE_DOT = RFC5892::testeMiddleDotRule;
    private static BiPredicate<String, Integer> RULE_ZERO_WIDTH_JOINER = RFC5892::testZeroWidthJoiner;
    private static BiPredicate<String, Integer> RULE_ZERO_WIDTH_NON_JOINER = RFC5892::testZeroWidthNonJoiner;
    private static BiPredicate<String, Integer> ALLOWED_CHARACTER = RFC5892::testAllowedCharacter;
    private static BiPredicate<String, Integer> LTR = RFC5892::testLTR;
    private static BiPredicate<String, Integer> RTL = RFC5892::testRTL;
    private static BiPredicate<String, Integer> IDNA_RULES = ALLOWED_CHARACTER.and(RULE_ARABIC_INDIC_DIGITS_RULE).and(RULE_EXTENDED_ARABIC_INDIC_DIGITS_RULE).and(RULE_GREEK_LOWER_NUMERAL_SIGN).and(RULE_HEBREW_GERESH_GERSHAYIM).and(RULE_KATAKANA_MIDDLE_DOT).and(RULE_MIDDLE_DOT).and(RULE_ZERO_WIDTH_JOINER).and(RULE_ZERO_WIDTH_NON_JOINER);

    private static boolean isContextJ(int codepoint) {
        if (CONTEXTJ.isEmpty()) {
            RFC5892.loadDerivedProperties();
        }
        return CONTEXTJ.get(codepoint);
    }

    private static boolean isContextO(int codepoint) {
        if (CONTEXTO.isEmpty()) {
            RFC5892.loadDerivedProperties();
        }
        return CONTEXTO.get(codepoint);
    }

    private static boolean isDisallowed(int codepoint) {
        if (DISALLOWED.isEmpty()) {
            RFC5892.loadDerivedProperties();
        }
        return DISALLOWED.get(codepoint);
    }

    private static boolean isUnassigned(int codepoint) {
        if (UNASSIGNED.isEmpty()) {
            RFC5892.loadDerivedProperties();
        }
        return UNASSIGNED.get(codepoint);
    }

    private static boolean testAllowedCharacter(String s2, int i) {
        int c = s2.codePointAt(i);
        return !RFC5892.isDisallowed(c) && !RFC5892.isUnassigned(c) && !RFC5892.isContextJ(c) && !RFC5892.isContextO(c);
    }

    public static boolean isValid(String value) {
        String[] labels;
        for (String label : labels = value.split("\\.")) {
            BiPredicate<String, Integer> rules;
            if (label.isEmpty()) continue;
            String unicode = label;
            if (RFC5892.isACE(label) && (unicode = IDN.toUnicode(label, 2)).equalsIgnoreCase(label)) {
                return false;
            }
            int len = unicode.length();
            if (!Normalizer.isNormalized(unicode, Normalizer.Form.NFC)) {
                return false;
            }
            if ('-' == unicode.charAt(0) || 45 == unicode.codePointBefore(len)) {
                return false;
            }
            if (4 <= len && 45 == unicode.codePointAt(2) && 45 == unicode.codePointAt(3)) {
                return false;
            }
            if (RFC5892.isCombiningMark(unicode.codePointAt(0))) {
                return false;
            }
            switch (Character.getDirectionality(unicode.codePointAt(0))) {
                case 0: {
                    rules = IDNA_RULES.and(LTR);
                    break;
                }
                case 1: 
                case 2: {
                    rules = IDNA_RULES.and(RTL);
                    break;
                }
                default: {
                    return false;
                }
            }
            for (int i = 0; i < len; ++i) {
                if (rules.test(unicode, i)) continue;
                return false;
            }
            try {
                String ace = IDN.toASCII(unicode, 2);
                if (63 >= ace.length()) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                Throwable t2 = e.getCause();
                if (t2 instanceof ParseException) {
                    String m4 = t2.getMessage();
                    return m4.startsWith("The input does not conform to the rules for BiDi code points");
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isACE(String value) {
        return ACE_PREFIX_LENGTH <= value.length() && ACE_PREFIX.equalsIgnoreCase(value.substring(0, ACE_PREFIX_LENGTH));
    }

    private static boolean isCombiningMark(int codepoint) {
        switch (Character.getType(codepoint)) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean testLTR(String s2, int i) {
        int c = s2.codePointAt(i);
        switch (Character.getDirectionality(c)) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static boolean testRTL(String s2, int i) {
        int c = s2.codePointAt(i);
        switch (Character.getDirectionality(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static boolean testGreekLowerNumeralSign(String s2, int i) {
        int c = s2.codePointAt(i);
        if (885 == c) {
            if (s2.length() == 1 + i) {
                return false;
            }
            int following = s2.codePointAt(i + 1);
            if (!UnicodeDatabase.isGreek(following)) {
                return false;
            }
        }
        return true;
    }

    private static boolean testHebrewPuncuation(String s2, int i) {
        int c = s2.codePointAt(i);
        if (1523 == c || 1524 == c) {
            if (0 == i) {
                return false;
            }
            int preceding = s2.codePointAt(i - 1);
            if (!UnicodeDatabase.isHebrew(preceding)) {
                return false;
            }
        }
        return true;
    }

    private static boolean testKatakanaMiddleDot(String s2, int i) {
        int c = s2.codePointAt(i);
        if (12539 == c) {
            if (s2.length() == 1 + i) {
                return false;
            }
            int following = s2.codePointAt(i + 1);
            if (!UnicodeDatabase.isKatakana(following)) {
                return false;
            }
        }
        return true;
    }

    private static boolean testeMiddleDotRule(String s2, int i) {
        int c = s2.codePointAt(i);
        if (183 == c) {
            if (0 == i) {
                return false;
            }
            if (s2.length() == 1 + i) {
                return false;
            }
            int preceding = s2.codePointAt(i - 1);
            int following = s2.codePointAt(i + 1);
            if (108 != preceding || 108 != following) {
                return false;
            }
        }
        return true;
    }

    private static boolean testZeroWidthJoiner(String s2, int i) {
        int c = s2.codePointAt(i);
        if (8205 == c) {
            if (0 == i) {
                return false;
            }
            int preceding = s2.codePointAt(i - 1);
            if (2381 != preceding) {
                return false;
            }
        }
        return true;
    }

    private static boolean testZeroWidthNonJoiner(String s2, int i) {
        int c = s2.codePointAt(i);
        if (8204 == c) {
            int j;
            if (0 == i) {
                return false;
            }
            int preceding = s2.codePointBefore(i);
            if (2381 == preceding) {
                return true;
            }
            for (j = i; 0 < j && UnicodeDatabase.isJoinTypeTransparent(s2.codePointBefore(j)); --j) {
            }
            if (0 == j) {
                return false;
            }
            preceding = s2.codePointBefore(j);
            if (!UnicodeDatabase.isJoinTypeLeft(preceding) && !UnicodeDatabase.isJoinTypeDual(preceding)) {
                return false;
            }
            int len = s2.length();
            if (len == j) {
                return false;
            }
            for (j = i + 1; j < len && UnicodeDatabase.isJoinTypeTransparent(s2.codePointAt(j)); ++j) {
            }
            if (len == j) {
                return false;
            }
            int following = s2.codePointAt(j);
            if (!UnicodeDatabase.isJoinTypeRight(following) && !UnicodeDatabase.isJoinTypeDual(following)) {
                return false;
            }
        }
        return true;
    }

    private static boolean testArabicIndicDigit(String s2, int i) {
        int c = s2.codePointAt(i);
        if (UnicodeDatabase.isArabicIndicDigit(c)) {
            return !s2.codePoints().anyMatch(UnicodeDatabase::isExtendedArabicIndicDigit);
        }
        return true;
    }

    private static boolean testExtendedArabicIndicDigit(String s2, int i) {
        int c = s2.codePointAt(i);
        if (UnicodeDatabase.isExtendedArabicIndicDigit(c)) {
            return !s2.codePoints().anyMatch(UnicodeDatabase::isArabicIndicDigit);
        }
        return true;
    }

    private static synchronized void loadDerivedProperties() {
        if (DISALLOWED.isEmpty()) {
            UCDLoader.loadMapping("/ucd/RFC5892-appendix-B.txt", v -> {
                switch (v) {
                    case "CONTEXTJ": {
                        return CONTEXTJ;
                    }
                    case "CONTEXTO": {
                        return CONTEXTO;
                    }
                    case "DISALLOWED": {
                        return DISALLOWED;
                    }
                    case "UNASSIGNED": {
                        return UNASSIGNED;
                    }
                }
                return null;
            });
            CONTEXTJ.clear(8205);
            CONTEXTJ.clear(8204);
            CONTEXTO.clear(1632, 1642);
            CONTEXTO.clear(1776, 1786);
            CONTEXTO.clear(885);
            CONTEXTO.clear(1523);
            CONTEXTO.clear(1524);
            CONTEXTO.clear(12539);
            CONTEXTO.clear(183);
        }
    }
}

