/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketUtil;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketWSClient;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher;
import org.wso2.carbon.apimgt.gateway.utils.APIMgtGoogleAnalyticsUtils;
import org.wso2.carbon.apimgt.impl.APIManagerAnalyticsConfiguration;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.usage.publisher.APIMgtUsageDataPublisher;
import org.wso2.carbon.apimgt.usage.publisher.DataPublisherUtil;
import org.wso2.carbon.apimgt.usage.publisher.dto.ExecutionTimeDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.RequestResponseStreamDTO;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.ganalytics.publisher.GoogleAnalyticsData;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class WebsocketInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Log log;
    private String tenantDomain;
    private static APIMgtUsageDataPublisher usageDataPublisher;
    private String uri;
    private String apiContextUri;
    private String version;
    private APIKeyValidationInfoDTO infoDTO = new APIKeyValidationInfoDTO();
    private HttpHeaders headers = new DefaultHttpHeaders();
    private String token;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        WebsocketInboundHandler.ajc$preClinit();
        log = LogFactory.getLog(WebsocketInboundHandler.class);
    }

    public WebsocketInboundHandler() {
        this.initializeDataPublisher();
    }

    private void initializeDataPublisher() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        WebsocketInboundHandler.initializeDataPublisher_aroundBody0(this, joinPoint);
    }

    private String getVersionFromUrl(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return string.replaceFirst(".*/([^/?]+).*", "$1");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ChannelHandlerContext channelHandlerContext = ctx;
        Object object = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)channelHandlerContext, (Object)object);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, channelHandlerContext, object, joinPoint};
            MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        WebsocketInboundHandler.channelRead_aroundBody4(this, channelHandlerContext, object, joinPoint);
    }

    private boolean validateOAuthHeader(FullHttpRequest req) throws APISecurityException {
        FullHttpRequest fullHttpRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)fullHttpRequest);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, fullHttpRequest, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return WebsocketInboundHandler.validateOAuthHeader_aroundBody6(this, fullHttpRequest, joinPoint);
    }

    protected APIKeyValidationInfoDTO getApiKeyDataForWSClient(String apiKey) throws APISecurityException {
        String string = apiKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (APIKeyValidationInfoDTO)MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return WebsocketInboundHandler.getApiKeyDataForWSClient_aroundBody8(this, string, joinPoint);
    }

    protected APIManagerAnalyticsConfiguration getApiManagerAnalyticsConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerAnalyticsConfiguration)MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return WebsocketInboundHandler.getApiManagerAnalyticsConfiguration_aroundBody10(this, joinPoint);
    }

    public boolean doThrottle(ChannelHandlerContext ctx, WebSocketFrame msg) {
        ChannelHandlerContext channelHandlerContext = ctx;
        WebSocketFrame webSocketFrame = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)channelHandlerContext, (Object)webSocketFrame);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, channelHandlerContext, webSocketFrame, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return WebsocketInboundHandler.doThrottle_aroundBody12(this, channelHandlerContext, webSocketFrame, joinPoint);
    }

    protected String getRemoteIP(ChannelHandlerContext ctx) {
        ChannelHandlerContext channelHandlerContext = ctx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)channelHandlerContext);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, channelHandlerContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return WebsocketInboundHandler.getRemoteIP_aroundBody14(this, channelHandlerContext, joinPoint);
    }

    private void publishRequestEvent(APIKeyValidationInfoDTO infoDTO, String clientIp, boolean isThrottledOut) {
        APIKeyValidationInfoDTO aPIKeyValidationInfoDTO = infoDTO;
        String string = clientIp;
        boolean bl = isThrottledOut;
        Object[] objectArray = new Object[]{aPIKeyValidationInfoDTO, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, aPIKeyValidationInfoDTO, string, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new WebsocketInboundHandler$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        WebsocketInboundHandler.publishRequestEvent_aroundBody16(this, aPIKeyValidationInfoDTO, string, bl, joinPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void initializeDataPublisher_aroundBody0(WebsocketInboundHandler ajc$this, JoinPoint joinPoint) {
        if (APIUtil.isAnalyticsEnabled() && usageDataPublisher == null) {
            String publisherClass = ajc$this.getApiManagerAnalyticsConfiguration().getPublisherClass();
            try {
                WebsocketInboundHandler websocketInboundHandler = ajc$this;
                synchronized (websocketInboundHandler) {
                    if (usageDataPublisher == null) {
                        try {
                            log.debug((Object)"Instantiating Web Socket Data Publisher");
                            usageDataPublisher = (APIMgtUsageDataPublisher)APIUtil.getClassForName((String)publisherClass).newInstance();
                            usageDataPublisher.init();
                        }
                        catch (ClassNotFoundException e) {
                            log.error((Object)("Class not found " + publisherClass), (Throwable)e);
                        }
                        catch (InstantiationException e) {
                            log.error((Object)("Error instantiating " + publisherClass), (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            log.error((Object)("Illegal access to " + publisherClass), (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Cannot publish event. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static final /* synthetic */ void channelRead_aroundBody4(WebsocketInboundHandler ajc$this, ChannelHandlerContext ctx, Object msg, JoinPoint joinPoint) {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            ajc$this.uri = req.getUri();
            URI uriTemp = new URI(ajc$this.uri);
            ajc$this.apiContextUri = new URI(uriTemp.getScheme(), uriTemp.getAuthority(), uriTemp.getPath(), null, uriTemp.getFragment()).toString();
            ajc$this.tenantDomain = req.getUri().contains("/t/") ? MultitenantUtils.getTenantDomainFromUrl((String)req.getUri()) : "carbon.super";
            String useragent = req.headers().get("User-Agent");
            useragent = useragent != null ? useragent : "-";
            ajc$this.headers.add("User-Agent", (Object)useragent);
            if (!ajc$this.validateOAuthHeader(req)) {
                ctx.writeAndFlush((Object)new TextWebSocketFrame("Invalid Credentials"));
                throw new APISecurityException(900901, "Invalid Credentials");
            }
            if (!"carbon.super".equals(ajc$this.tenantDomain)) {
                req.setUri(req.getUri().replaceFirst("/", "-"));
                String modifiedUri = ajc$this.uri.replaceFirst("/t/", "-t/");
                req.setUri(modifiedUri);
                msg = req;
            } else {
                req.setUri(ajc$this.uri);
            }
            if (StringUtils.isNotEmpty((CharSequence)ajc$this.token)) {
                ((FullHttpRequest)msg).headers().set("websocket.custom.header.X-JWT-Assertion", (Object)ajc$this.token);
            }
            ctx.fireChannelRead(msg);
            GoogleAnalyticsData.DataBuilder gaData = new GoogleAnalyticsData.DataBuilder(null, null, null, null).setDocumentPath(ajc$this.uri).setDocumentHostName(DataPublisherUtil.getHostAddress()).setSessionControl("end").setCacheBuster(APIMgtGoogleAnalyticsUtils.getCacheBusterId()).setIPOverride(ctx.channel().remoteAddress().toString());
            APIMgtGoogleAnalyticsUtils gaUtils = new APIMgtGoogleAnalyticsUtils();
            gaUtils.init(ajc$this.tenantDomain);
            gaUtils.publishGATrackingData(gaData, req.headers().get("User-Agent"), ajc$this.headers.get("Authorization"));
            return;
        }
        if (!(msg instanceof WebSocketFrame)) return;
        boolean isThrottledOut = ajc$this.doThrottle(ctx, (WebSocketFrame)msg);
        String clientIp = ajc$this.getRemoteIP(ctx);
        if (isThrottledOut) {
            ctx.fireChannelRead(msg);
        } else {
            ctx.writeAndFlush((Object)new TextWebSocketFrame("Websocket frame throttled out"));
        }
        if (!APIUtil.isAnalyticsEnabled()) return;
        ajc$this.publishRequestEvent(ajc$this.infoDTO, clientIp, isThrottledOut);
    }

    static final /* synthetic */ boolean validateOAuthHeader_aroundBody6(WebsocketInboundHandler ajc$this, FullHttpRequest req, JoinPoint joinPoint) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(ajc$this.tenantDomain, true);
            ajc$this.version = ajc$this.getVersionFromUrl(ajc$this.uri);
            if (!req.headers().contains("Authorization")) {
                QueryStringDecoder decoder = new QueryStringDecoder(req.getUri());
                Map requestMap = decoder.parameters();
                if (requestMap.containsKey("access_token")) {
                    req.headers().add("Authorization", (Object)("Bearer " + (String)((List)requestMap.get("access_token")).get(0)));
                    requestMap.remove("access_token");
                } else {
                    log.error((Object)"No Authorization Header or access_token query parameter present");
                    return false;
                }
            }
            String authorizationHeader = req.headers().get("Authorization");
            ajc$this.headers.add("Authorization", (Object)authorizationHeader);
            String[] auth = authorizationHeader.split(" ");
            if ("Bearer".equals(auth[0])) {
                String cacheKey;
                APIKeyValidationInfoDTO info;
                boolean isJwtToken = false;
                String apiKey = auth[1];
                if (WebsocketUtil.isRemoveOAuthHeadersFromOutMessage()) {
                    req.headers().remove("Authorization");
                }
                boolean bl = isJwtToken = StringUtils.isNotEmpty((CharSequence)apiKey) && apiKey.contains(".") && APIUtil.isValidJWT((String)apiKey);
                if (isJwtToken) {
                    log.debug((Object)"The token was identified as a JWT token");
                    AuthenticationContext authenticationContext = new JWTValidator(null, null).authenticateForWebSocket(apiKey, ajc$this.apiContextUri, ajc$this.version);
                    if (authenticationContext == null || !authenticationContext.isAuthenticated()) {
                        return false;
                    }
                    APIKeyValidationInfoDTO info2 = new APIKeyValidationInfoDTO();
                    info2.setAuthorized(authenticationContext.isAuthenticated());
                    info2.setApplicationTier(authenticationContext.getApplicationTier());
                    info2.setTier(authenticationContext.getTier());
                    info2.setSubscriberTenantDomain(authenticationContext.getSubscriberTenantDomain());
                    info2.setSubscriber(authenticationContext.getSubscriber());
                    info2.setStopOnQuotaReach(authenticationContext.isStopOnQuotaReach());
                    info2.setApiName(authenticationContext.getApiName());
                    info2.setApplicationId(authenticationContext.getApplicationId());
                    info2.setType(authenticationContext.getKeyType());
                    info2.setApiPublisher(authenticationContext.getApiPublisher());
                    info2.setApplicationName(authenticationContext.getApplicationName());
                    info2.setConsumerKey(authenticationContext.getConsumerKey());
                    info2.setEndUserName(authenticationContext.getUsername());
                    if ("PRODUCTION".equals(info2.getType())) {
                        ajc$this.uri = "/_PRODUCTION_" + ajc$this.uri;
                    } else if ("SANDBOX".equals(info2.getType())) {
                        ajc$this.uri = "/_SANDBOX_" + ajc$this.uri;
                    }
                    ajc$this.infoDTO = info2;
                    boolean bl2 = authenticationContext.isAuthenticated();
                    return bl2;
                }
                log.debug((Object)"The token was identified as an OAuth token");
                if (WebsocketUtil.isGatewayTokenCacheEnabled() && (info = WebsocketUtil.validateCache(apiKey, cacheKey = WebsocketUtil.getAccessTokenCacheKey(apiKey, ajc$this.uri))) != null) {
                    if ("PRODUCTION".equals(info.getType())) {
                        ajc$this.uri = "/_PRODUCTION_" + ajc$this.uri;
                    } else if ("SANDBOX".equals(info.getType())) {
                        ajc$this.uri = "/_SANDBOX_" + ajc$this.uri;
                    }
                    ajc$this.infoDTO = info;
                    boolean bl3 = info.isAuthorized();
                    return bl3;
                }
                String keyValidatorClientType = APISecurityUtils.getKeyValidatorClientType();
                if (!"WSClient".equals(keyValidatorClientType)) {
                    return false;
                }
                info = ajc$this.getApiKeyDataForWSClient(apiKey);
                if (info == null || !info.isAuthorized()) {
                    return false;
                }
                if (info.getApiName() != null && info.getApiName().contains("*")) {
                    String[] str = info.getApiName().split("\\*");
                    ajc$this.version = str[1];
                    ajc$this.uri = String.valueOf(ajc$this.uri) + "/" + str[1];
                    info.setApiName(str[0]);
                }
                if (WebsocketUtil.isGatewayTokenCacheEnabled()) {
                    cacheKey = WebsocketUtil.getAccessTokenCacheKey(apiKey, ajc$this.uri);
                    WebsocketUtil.putCache(info, apiKey, cacheKey);
                }
                if ("PRODUCTION".equals(info.getType())) {
                    ajc$this.uri = "/_PRODUCTION_" + ajc$this.uri;
                } else if ("SANDBOX".equals(info.getType())) {
                    ajc$this.uri = "/_SANDBOX_" + ajc$this.uri;
                }
                ajc$this.token = info.getEndUserToken();
                ajc$this.infoDTO = info;
                return true;
            }
            return false;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    static final /* synthetic */ APIKeyValidationInfoDTO getApiKeyDataForWSClient_aroundBody8(WebsocketInboundHandler ajc$this, String apiKey, JoinPoint joinPoint) {
        return new WebsocketWSClient().getAPIKeyData(ajc$this.apiContextUri, ajc$this.version, apiKey);
    }

    static final /* synthetic */ APIManagerAnalyticsConfiguration getApiManagerAnalyticsConfiguration_aroundBody10(WebsocketInboundHandler ajc$this, JoinPoint joinPoint) {
        return DataPublisherUtil.getApiManagerAnalyticsConfiguration();
    }

    static final /* synthetic */ boolean doThrottle_aroundBody12(WebsocketInboundHandler ajc$this, ChannelHandlerContext ctx, WebSocketFrame msg, JoinPoint joinPoint) {
        String apiLevelThrottleKey;
        String applicationLevelTier = ajc$this.infoDTO.getApplicationTier();
        String apiLevelTier = ajc$this.infoDTO.getApiTier();
        String subscriptionLevelTier = ajc$this.infoDTO.getTier();
        String resourceLevelTier = apiLevelTier;
        String authorizedUser = "carbon.super".equalsIgnoreCase(ajc$this.infoDTO.getSubscriberTenantDomain()) ? String.valueOf(ajc$this.infoDTO.getSubscriber()) + "@" + ajc$this.infoDTO.getSubscriberTenantDomain() : ajc$this.infoDTO.getSubscriber();
        String apiName = ajc$this.infoDTO.getApiName();
        String apiContext = ajc$this.apiContextUri;
        String apiVersion = ajc$this.version;
        String appTenant = ajc$this.infoDTO.getSubscriberTenantDomain();
        String apiTenant = ajc$this.tenantDomain;
        String appId = ajc$this.infoDTO.getApplicationId();
        String applicationLevelThrottleKey = String.valueOf(appId) + ":" + authorizedUser;
        String resourceLevelThrottleKey = apiLevelThrottleKey = String.valueOf(apiContext) + ":" + apiVersion;
        String subscriptionLevelThrottleKey = String.valueOf(appId) + ":" + apiContext + ":" + apiVersion;
        String messageId = UIDGenerator.generateURNString();
        String remoteIP = ajc$this.getRemoteIP(ctx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remote IP address : " + remoteIP));
        }
        if (remoteIP.indexOf(":") > 0) {
            remoteIP = remoteIP.substring(1, remoteIP.indexOf(":"));
        }
        JSONObject jsonObMap = new JSONObject();
        if (remoteIP != null && remoteIP.length() > 0) {
            try {
                InetAddress address = APIUtil.getAddress((String)remoteIP);
                if (address instanceof Inet4Address) {
                    jsonObMap.put("ip", APIUtil.ipToLong((String)remoteIP));
                } else if (address instanceof Inet6Address) {
                    jsonObMap.put("ipv6", (Object)APIUtil.ipToBigInteger((String)remoteIP));
                }
            }
            catch (UnknownHostException e) {
                log.error((Object)("Error while parsing host IP " + remoteIP), (Throwable)e);
            }
        }
        jsonObMap.put("messageSize", msg.content().capacity());
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(ajc$this.tenantDomain, true);
            boolean isThrottled = WebsocketUtil.isThrottled(resourceLevelThrottleKey, subscriptionLevelThrottleKey, applicationLevelThrottleKey);
            if (isThrottled) {
                return false;
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        Object[] objects = new Object[]{messageId, applicationLevelThrottleKey, applicationLevelTier, apiLevelThrottleKey, apiLevelTier, subscriptionLevelThrottleKey, subscriptionLevelTier, resourceLevelThrottleKey, resourceLevelTier, authorizedUser, apiContext, apiVersion, appTenant, apiTenant, appId, apiName, jsonObMap.toString()};
        Event event = new Event("org.wso2.throttle.request.stream:1.0.0", System.currentTimeMillis(), null, null, objects);
        ServiceReferenceHolder.getInstance().getThrottleDataPublisher();
        ThrottleDataPublisher.getDataPublisher().tryPublish(event);
        return true;
    }

    static final /* synthetic */ String getRemoteIP_aroundBody14(WebsocketInboundHandler ajc$this, ChannelHandlerContext ctx, JoinPoint joinPoint) {
        return ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
    }

    static final /* synthetic */ void publishRequestEvent_aroundBody16(WebsocketInboundHandler ajc$this, APIKeyValidationInfoDTO infoDTO, String clientIp, boolean isThrottledOut, JoinPoint joinPoint) {
        long requestTime = System.currentTimeMillis();
        String useragent = ajc$this.headers.get("User-Agent");
        try {
            String appOwner = infoDTO.getSubscriber();
            String keyType = infoDTO.getType();
            String correlationID = UUID.randomUUID().toString();
            RequestResponseStreamDTO requestPublisherDTO = new RequestResponseStreamDTO();
            requestPublisherDTO.setApiName(infoDTO.getApiName());
            requestPublisherDTO.setApiCreator(infoDTO.getApiPublisher());
            requestPublisherDTO.setApiCreatorTenantDomain(MultitenantUtils.getTenantDomain((String)infoDTO.getApiPublisher()));
            requestPublisherDTO.setApiVersion(String.valueOf(infoDTO.getApiName()) + ':' + ajc$this.version);
            requestPublisherDTO.setApplicationId(infoDTO.getApplicationId());
            requestPublisherDTO.setApplicationName(infoDTO.getApplicationName());
            requestPublisherDTO.setApplicationOwner(appOwner);
            requestPublisherDTO.setUserIp(clientIp);
            requestPublisherDTO.setApplicationConsumerKey(infoDTO.getConsumerKey());
            requestPublisherDTO.setApiContext(ajc$this.apiContextUri);
            requestPublisherDTO.setThrottledOut(isThrottledOut);
            requestPublisherDTO.setApiHostname(DataPublisherUtil.getHostAddress());
            requestPublisherDTO.setApiMethod("-");
            requestPublisherDTO.setRequestTimestamp(requestTime);
            requestPublisherDTO.setApiResourcePath("-");
            requestPublisherDTO.setApiResourceTemplate("-");
            requestPublisherDTO.setUserAgent(useragent);
            requestPublisherDTO.setUsername(infoDTO.getEndUserName());
            requestPublisherDTO.setUserTenantDomain(ajc$this.tenantDomain);
            requestPublisherDTO.setApiTier(infoDTO.getTier());
            requestPublisherDTO.setApiVersion(ajc$this.version);
            requestPublisherDTO.setMetaClientType(keyType);
            requestPublisherDTO.setCorrelationID(correlationID);
            requestPublisherDTO.setUserAgent(useragent);
            requestPublisherDTO.setCorrelationID(correlationID);
            requestPublisherDTO.setGatewayType("SYNAPSE");
            requestPublisherDTO.setLabel("Synapse");
            requestPublisherDTO.setProtocol("WebSocket");
            requestPublisherDTO.setDestination("-");
            requestPublisherDTO.setBackendTime(0L);
            requestPublisherDTO.setResponseCacheHit(false);
            requestPublisherDTO.setResponseCode(0);
            requestPublisherDTO.setResponseSize(0L);
            requestPublisherDTO.setServiceTime(0L);
            requestPublisherDTO.setResponseTime(0L);
            ExecutionTimeDTO executionTime = new ExecutionTimeDTO();
            executionTime.setBackEndLatency(0L);
            executionTime.setOtherLatency(0L);
            executionTime.setRequestMediationLatency(0L);
            executionTime.setResponseMediationLatency(0L);
            executionTime.setSecurityLatency(0L);
            executionTime.setThrottlingLatency(0L);
            requestPublisherDTO.setExecutionTime(executionTime);
            usageDataPublisher.publishEvent(requestPublisherDTO);
        }
        catch (Exception e) {
            log.error((Object)("Cannot publish event. " + e.getMessage()), (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebsocketInboundHandler.java", WebsocketInboundHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeDataPublisher", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "", "", "", "void"), 86);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getVersionFromUrl", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "java.lang.String", "url", "", "java.lang.String"), 119);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "channelRead", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "io.netty.channel.ChannelHandlerContext:java.lang.Object", "ctx:msg", "java.lang.Exception", "void"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateOAuthHeader", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "io.netty.handler.codec.http.FullHttpRequest", "req", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "boolean"), 216);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApiKeyDataForWSClient", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "java.lang.String", "apiKey", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO"), 339);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApiManagerAnalyticsConfiguration", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerAnalyticsConfiguration"), 343);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doThrottle", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "io.netty.channel.ChannelHandlerContext:io.netty.handler.codec.http.websocketx.WebSocketFrame", "ctx:msg", "", "boolean"), 354);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getRemoteIP", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "io.netty.channel.ChannelHandlerContext", "ctx", "", "java.lang.String"), 427);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "publishRequestEvent", "org.wso2.carbon.apimgt.gateway.handlers.WebsocketInboundHandler", "org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO:java.lang.String:boolean", "infoDTO:clientIp:isThrottledOut", "", "void"), 438);
    }
}

