/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.threatprotection;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.APIMThreatAnalyzer;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.XMLAnalyzer;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.ConfigurationHolder;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.JSONConfig;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.XMLConfig;
import org.wso2.carbon.apimgt.gateway.threatprotection.pool.AnalyzerPool;
import org.wso2.carbon.apimgt.gateway.threatprotection.pool.JSONAnalyzerFactory;
import org.wso2.carbon.apimgt.gateway.threatprotection.pool.XMLAnalyzerFactory;

public class AnalyzerHolder {
    private static Logger log;
    private static AnalyzerHolder instance;
    private static AnalyzerPool<XMLAnalyzer> xmlAnalyzerAnalyzerPool;
    private static AnalyzerPool<JSONAnalyzer> jsonAnalyzerAnalyzerPool;
    private static GenericObjectPoolConfig poolConfig;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        AnalyzerHolder.ajc$preClinit();
        log = LoggerFactory.getLogger(AnalyzerHolder.class);
        instance = new AnalyzerHolder();
        poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(200);
        poolConfig.setBlockWhenExhausted(false);
        poolConfig.setMaxWaitMillis(0L);
        xmlAnalyzerAnalyzerPool = new AnalyzerPool(new XMLAnalyzerFactory(), poolConfig);
        jsonAnalyzerAnalyzerPool = new AnalyzerPool(new JSONAnalyzerFactory(), poolConfig);
    }

    private AnalyzerHolder() {
    }

    public static AnalyzerHolder getInstance() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            return (AnalyzerHolder)MethodTimeLogger.aspectOf().log(new AnalyzerHolder$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AnalyzerHolder.instance;
    }

    public static APIMThreatAnalyzer getAnalyzer(String contentType) {
        String string = contentType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            return (APIMThreatAnalyzer)MethodTimeLogger.aspectOf().log(new AnalyzerHolder$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AnalyzerHolder.getAnalyzer_aroundBody2(string, joinPoint);
    }

    public static void returnObject(APIMThreatAnalyzer analyzer) {
        APIMThreatAnalyzer aPIMThreatAnalyzer = analyzer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)aPIMThreatAnalyzer);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{aPIMThreatAnalyzer, joinPoint};
            MethodTimeLogger.aspectOf().log(new AnalyzerHolder$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        AnalyzerHolder.returnObject_aroundBody4(aPIMThreatAnalyzer, joinPoint);
    }

    static final /* synthetic */ APIMThreatAnalyzer getAnalyzer_aroundBody2(String contentType, JoinPoint joinPoint) {
        APIMThreatAnalyzer analyzer = null;
        if ("text/xml".equalsIgnoreCase(contentType) || "application/xml".equalsIgnoreCase(contentType)) {
            try {
                analyzer = (APIMThreatAnalyzer)xmlAnalyzerAnalyzerPool.borrowObject();
                XMLConfig xmlConfig = ConfigurationHolder.getXmlConfig();
                analyzer.configure(xmlConfig);
            }
            catch (Exception e) {
                log.error("Threat Protection: Error occurred while getting an object from the pool.", (Throwable)e);
            }
        } else if ("text/json".equalsIgnoreCase(contentType) || "application/json".equalsIgnoreCase(contentType)) {
            try {
                analyzer = (APIMThreatAnalyzer)jsonAnalyzerAnalyzerPool.borrowObject();
                JSONConfig jsonConfig = ConfigurationHolder.getJsonConfig();
                analyzer.configure(jsonConfig);
            }
            catch (Exception e) {
                log.error("Threat Protection: Error occurred while getting an object from the pool.", (Throwable)e);
            }
        }
        return analyzer;
    }

    static final /* synthetic */ void returnObject_aroundBody4(APIMThreatAnalyzer analyzer, JoinPoint joinPoint) {
        if (analyzer instanceof JSONAnalyzer) {
            jsonAnalyzerAnalyzerPool.returnObject((JSONAnalyzer)analyzer);
        } else if (analyzer instanceof XMLAnalyzer) {
            xmlAnalyzerAnalyzerPool.returnObject((XMLAnalyzer)analyzer);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnalyzerHolder.java", AnalyzerHolder.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getInstance", "org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder", "", "", "", "org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getAnalyzer", "org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder", "java.lang.String", "contentType", "", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.APIMThreatAnalyzer"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "returnObject", "org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.APIMThreatAnalyzer", "analyzer", "", "void"), 101);
    }
}

