/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.mediation.dependency.mgt.CustomResolversListener;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingService;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingServiceImpl;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementServiceImpl;
import org.wso2.carbon.mediation.dependency.mgt.services.ResolverRegistrationService;
import org.wso2.carbon.mediation.dependency.mgt.services.ResolverRegistrationServiceImpl;

@Component(name="esb.config.dependency.mgt", immediate=true)
public class DependencyManagementServiceComponent {
    private final Log log = LogFactory.getLog(this.getClass());
    private final List<String> pendingResolvers = new ArrayList<String>();
    private CustomResolversListener resolverListener;
    private BundleContext bndCtx;
    private Timer timer = new Timer();
    private ConfigurationTrackingServiceImpl configurationTrackingService;

    @Activate
    protected void activate(ComponentContext cmpCtx) {
        this.bndCtx = cmpCtx.getBundleContext();
        this.bndCtx.registerService(ResolverRegistrationService.class.getName(), (Object)new ResolverRegistrationServiceImpl(), null);
        this.configurationTrackingService = new ConfigurationTrackingServiceImpl(this.bndCtx);
        this.bndCtx.registerService(DependencyManagementService.class.getName(), (Object)new DependencyManagementServiceImpl(), null);
        this.configurationTrackingService.setServiceRegistered(true);
        this.resolverListener = new CustomResolversListener(this, this.bndCtx);
        for (Bundle bundle : this.bndCtx.getBundles()) {
            Dictionary headers = bundle.getHeaders();
            String value = (String)headers.get("MediatorDependencyResolver");
            if (value == null) continue;
            this.resolverListener.addResolverBundle(value.trim(), bundle);
        }
        if (this.resolverListener.registerBundleListener()) {
            this.resolverListener.start();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"No custom dependency resolvers were found... Skipping...");
        }
        if (this.pendingResolvers.isEmpty()) {
            this.finishInitialization();
        } else {
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (!DependencyManagementServiceComponent.this.pendingResolvers.isEmpty()) {
                            DependencyManagementServiceComponent.this.log.warn((Object)"Carbon initialization is delayed due to the following uninitialized mediator dependency resolvers...");
                            for (String configItem : DependencyManagementServiceComponent.this.pendingResolvers) {
                                DependencyManagementServiceComponent.this.log.warn((Object)("Waiting for required resolver " + configItem));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 5000L, 10000L);
        }
    }

    private void finishInitialization() {
        this.resolverListener.unregisterBundleListener();
        this.timer.cancel();
        this.bndCtx.registerService(ConfigurationTrackingService.class.getName(), (Object)(this.configurationTrackingService != null ? this.configurationTrackingService : new ConfigurationTrackingServiceImpl(this.bndCtx)), null);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Configuration tracking service initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingResolver(String name) {
        List<String> list = this.pendingResolvers;
        synchronized (list) {
            this.pendingResolvers.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePendingResolver(String name) {
        List<String> list = this.pendingResolvers;
        synchronized (list) {
            if (this.pendingResolvers.contains(name)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Pending resolver removed : " + name));
                }
                this.pendingResolvers.remove(name);
                if (this.pendingResolvers.isEmpty()) {
                    this.finishInitialization();
                }
            }
        }
    }
}

