/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class MessageStoreRegistryStore
extends AbstractRegistryStore {
    public MessageStoreRegistryStore(UserRegistry registry, String configName) {
        super(registry, configName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        ArrayList<OMElement> messageStoreElements = new ArrayList();
        try {
            messageStoreElements = this.getChildElementsInPath(this.getConfigurationPath());
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the list of Message Stores from the registry in path : " + this.getConfigurationPath(), (Exception)((Object)e));
        }
        return messageStoreElements;
    }

    @Override
    public OMElement getElement(String name) {
        return null;
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (element.getLocalName().equals(XMLConfigConstants.MESSAGE_STORE_ELT.getLocalPart())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Persisting Message Store : " + name + " to the registry"));
            }
            String messageStorePath = this.getConfigurationPath() + "/" + name;
            AppDeployerUtils.attachArtifactToOwnerApp((String)fileName, (String)"synapse/message-store", (String)name, (int)this.registry.getTenantId());
            try {
                this.persistElement(element, messageStorePath, fileName);
            }
            catch (RegistryException e) {
                this.handleException("Unable to persist the Message Store  in the path : " + messageStorePath, (Exception)((Object)e));
            }
        } else {
            this.handleException("The element provided to persist is not a Message Store");
        }
    }

    @Override
    public void deleteElement(String name) {
        String messageStorePath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(messageStorePath)) {
                this.registry.delete(messageStorePath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the Message Store at path : " + messageStorePath, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "synapse-message-stores";
    }
}

