/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.IndexDocumentCreator;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class IndexingHandler
extends Handler {
    private static Log log = LogFactory.getLog(IndexingHandler.class);
    private static volatile AsyncIndexer asyncIndexer;

    public void put(RequestContext requestContext) throws RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Before put resources into indexer " + requestContext.getResourcePath().getPath()));
        }
        if (this.isIndexablePutOperation(requestContext) || Utils.getRegistryService() == null) {
            return;
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String path = this.getRegistryPath(requestContext);
        this.submitFileForIndexing(this.getIndexer(), requestContext.getResource(), path, null, carbonContext.getTenantId(), carbonContext.getTenantDomain());
        if (log.isDebugEnabled()) {
            log.debug((Object)(" After put resources into indexer " + requestContext.getResourcePath().getPath()));
        }
    }

    private void deleteFromIndex(String oldPath, int tenantId) throws RegistryException {
        this.getIndexer().getClient().deleteFromIndex(oldPath, tenantId);
    }

    private boolean isIndexable(RequestContext requestContext) {
        return this.isExecutingMountedHandlerChain(requestContext) || requestContext.getResource() == null || requestContext.getResource().getMediaType() == null || requestContext.getResource() instanceof Collection;
    }

    private boolean isIndexablePutOperation(RequestContext requestContext) {
        return requestContext.getRegistry().getRegistryContext() == null || requestContext.getResource() == null || requestContext.getResource().getMediaType() == null || requestContext.getResource() instanceof Collection;
    }

    private boolean isExecutingMountedHandlerChain(RequestContext requestContext) {
        return requestContext.getRegistry().getRegistryContext() == null || requestContext.getRegistry().getRegistryContext().isClone();
    }

    public Collection searchContent(RequestContext requestContext) throws RegistryException {
        String searchQuery = requestContext.getKeywords();
        UserRegistry registry = CurrentSession.getUserRegistry();
        ArrayList<String> filteredResults = new ArrayList<String>();
        try {
            SolrClient client = SolrClient.getInstance();
            SolrDocumentList results = client.query(searchQuery, CurrentSession.getTenantId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("result received " + results));
            }
            int i = 0;
            while ((long)i < results.getNumFound()) {
                SolrDocument solrDocument = (SolrDocument)results.get(i);
                String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
                if (this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                    filteredResults.add(path);
                }
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("filtered results " + filteredResults + " for user " + registry.getUserName()));
            }
        }
        catch (IndexerException e) {
            log.error((Object)"Unable to do Content Search", (Throwable)e);
        }
        String[] resourcePaths = filteredResults.toArray(new String[filteredResults.size()]);
        CollectionImpl searchResults = new CollectionImpl();
        searchResults.setContent((Object)resourcePaths);
        return searchResults;
    }

    private String getPathFromId(String id) {
        return id.substring(0, id.lastIndexOf("tenantId"));
    }

    private boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = this.getLoggedInUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Error while authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private String getLoggedInUserName() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
        if (this.isIndexable(requestContext)) {
            return;
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String path = this.getRegistryPath(requestContext);
        this.submitFileForIndexing(this.getIndexer(), requestContext.getResource(), path, requestContext.getSourceURL(), carbonContext.getTenantId(), carbonContext.getTenantDomain());
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        final String id = requestContext.getResourcePath().getPath();
        final int tenantId = CurrentSession.getTenantId();
        new Thread(new Runnable(){
            int tid;
            {
                this.tid = tenantId;
            }

            @Override
            public void run() {
                try {
                    IndexingHandler.this.deleteFromIndex(id, this.tid);
                }
                catch (SolrException e) {
                    log.error((Object)"Could not delete file for Solr server", (Throwable)e);
                }
                catch (RegistryException e) {
                    log.error((Object)"Could not delete file for Solr server", (Throwable)e);
                }
            }
        }).start();
    }

    public void putChild(RequestContext requestContext) throws RegistryException {
    }

    public void importChild(RequestContext requestContext) throws RegistryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncIndexer getIndexer() throws RegistryException {
        try {
            if (asyncIndexer == null) {
                IndexingHandler indexingHandler = this;
                synchronized (indexingHandler) {
                    if (asyncIndexer == null) {
                        asyncIndexer = null;
                        asyncIndexer = new AsyncIndexer();
                        new Thread(asyncIndexer).run();
                    }
                }
            }
            return asyncIndexer;
        }
        catch (SolrException e) {
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    private void submitFileForIndexing(AsyncIndexer indexer, Resource resource, String path, String sourceURL, int tenantId, String tenantDomain) {
        String mediaType = resource.getMediaType();
        if (mediaType == null && path != null) {
            try {
                mediaType = MediaTypesUtils.getMediaType((String)RegistryUtils.getResourceName((String)path));
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        if (mediaType == null || Utils.getRegistryService() == null || IndexingManager.getInstance().getIndexerForMediaType(mediaType) == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting file " + path + " for Indexing"));
        }
        try {
            String lcName = resource.getProperty("registry.LC.name");
            String lcState = lcName != null ? resource.getProperty("registry.lifecycle." + lcName + ".state") : null;
            AsyncIndexer.File2Index file2Index = new AsyncIndexer.File2Index(IndexingUtils.getByteContent(resource, sourceURL), mediaType, path, tenantId, tenantDomain, lcName, lcState);
            String resourcePath = file2Index.path;
            UserRegistry registry = IndexingManager.getInstance().getRegistry(file2Index.tenantId);
            if (resourcePath != null) {
                Resource resourceToIndex = registry.resourceExists(resourcePath) ? registry.get(resourcePath) : resource;
                IndexDocumentCreator indexDocumentCreator = new IndexDocumentCreator(file2Index, resourceToIndex);
                indexDocumentCreator.createIndexDocument();
                String symlinkPath = resourceToIndex.getProperty("registry.resource.symlink.path");
                if (symlinkPath != null) {
                    file2Index.path = symlinkPath;
                    indexDocumentCreator = new IndexDocumentCreator(file2Index, resourceToIndex);
                    indexDocumentCreator.createIndexDocument();
                }
            }
        }
        catch (RegistryException | IndexerException e) {
            log.error((Object)"An error occurred while submitting file for indexing", e);
        }
    }

    private String getRegistryPath(RequestContext requestContext) {
        String servicePath = requestContext.getResourcePath().getPath();
        List mounts = requestContext.getRegistry().getRegistryContext().getMounts();
        for (Mount mount : mounts) {
            String mountPath = mount.getPath();
            if (!servicePath.startsWith(mount.getTargetPath())) continue;
            return servicePath.replace(mount.getTargetPath(), mountPath);
        }
        return servicePath;
    }
}

