/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryConfigLoader {
    public static final String SKIP_CACHE = "skipCache";
    public static final String TRUE = "true";
    private static volatile RegistryConfigLoader registryConfigLoaderInstance = new RegistryConfigLoader();
    private static Log log = LogFactory.getLog(RegistryConfigLoader.class);
    private boolean startIndexing = true;
    private long startingDelayInSecs = 600L;
    private long indexingFreqInSecs = 60L;
    private String lastAccessTimeLocation = "/_system/local/repository/components/org.wso2.carbon.registry/indexing/lastaccesstime";
    private String skipRolesByRegex;
    private Map<String, Indexer> indexerMap = new LinkedHashMap<String, Indexer>();
    private List<Pattern> exclusionList = new ArrayList<Pattern>();
    private long batchSize = 50L;
    private int indexerPoolSize = 50;
    private boolean skipIndexingCache = false;
    private String solrServerUrl;

    public int getIndexerPoolSize() {
        return this.indexerPoolSize;
    }

    public boolean isSkipIndexingCache() {
        return this.skipIndexingCache;
    }

    public void setSkipIndexingCache(boolean skipIndexingCache) {
        this.skipIndexingCache = skipIndexingCache;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public String getSolrServerUrl() {
        return this.solrServerUrl;
    }

    private RegistryConfigLoader() {
        try {
            FileInputStream fileInputStream = new FileInputStream(RegistryConfigLoader.getConfigFile());
            StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)fileInputStream));
            OMElement configElement = builder.getDocumentElement();
            OMElement indexingConfig = configElement.getFirstChildWithName(new QName("indexingConfiguration"));
            if (indexingConfig != null) {
                this.loadIndexingConfiguration(indexingConfig);
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"registry.xml has not been found", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "error building registry.xml, check for badly formed xml";
            log.error((Object)msg, (Throwable)e);
        }
        catch (CarbonException e) {
            log.error((Object)"An error occurred during system variable replacement", (Throwable)e);
        }
    }

    public static RegistryConfigLoader getInstance() {
        return registryConfigLoaderInstance;
    }

    public long getIndexingFreqInSecs() {
        return this.indexingFreqInSecs;
    }

    public String getLastAccessTimeLocation() {
        return this.lastAccessTimeLocation;
    }

    public Map<String, Indexer> getIndexerMap() {
        return this.indexerMap;
    }

    public Pattern[] getExclusionPatterns() {
        return this.exclusionList.toArray(new Pattern[this.exclusionList.size()]);
    }

    public boolean IsStartIndexing() {
        return this.startIndexing;
    }

    public long getStartingDelayInSecs() {
        return this.startingDelayInSecs;
    }

    public String getSkipRolesByRegex() {
        return this.skipRolesByRegex;
    }

    private static File getConfigFile() throws RegistryException {
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null) {
            File registryXML = new File(configPath);
            if (!registryXML.exists()) {
                String msg = "Registry configuration file (registry.xml) file does not exist in the path " + configPath;
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            return registryXML;
        }
        String msg = "Cannot find registry.xml";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }

    private void loadIndexingConfiguration(OMElement indexingConfig) {
        OMElement startIndexingConfig = indexingConfig.getFirstChildWithName(new QName("startIndexing"));
        if (startIndexingConfig != null) {
            try {
                this.startIndexing = Boolean.parseBoolean(startIndexingConfig.getText());
            }
            catch (OMException e) {
                log.error((Object)("Error occurred when retrieving startIndexing, hence using the default value '" + this.startIndexing + "'"), (Throwable)e);
            }
        }
        try {
            this.startingDelayInSecs = Long.parseLong(indexingConfig.getFirstChildWithName(new QName("startingDelayInSeconds")).getText());
        }
        catch (OMException e) {
            log.error((Object)"Error occurred when retriving startingDelayInSeconds, hence using the default value", (Throwable)e);
        }
        try {
            this.indexingFreqInSecs = Long.parseLong(indexingConfig.getFirstChildWithName(new QName("indexingFrequencyInSeconds")).getText());
        }
        catch (OMException e) {
            log.error((Object)"Error occurred when retriving indexingFrequencyInSeconds, hence using the default value", (Throwable)e);
        }
        try {
            this.lastAccessTimeLocation = indexingConfig.getFirstChildWithName(new QName("lastAccessTimeLocation")).getText();
        }
        catch (OMException e) {
            log.error((Object)"Error occurred when retriving lastAccessTimeLocation, hence using the default value", (Throwable)e);
        }
        try {
            OMElement skipIndexingCacheEle = indexingConfig.getFirstChildWithName(new QName(SKIP_CACHE));
            if (skipIndexingCacheEle != null) {
                this.setSkipIndexingCache(TRUE.equals(skipIndexingCacheEle.getText()));
            }
        }
        catch (OMException e) {
            log.error((Object)"Error occurred when retrieving skipCache info, hence using the default value", (Throwable)e);
        }
        try {
            OMElement skipRolesByRegexElemet = indexingConfig.getFirstChildWithName(new QName("skipRolesByRegex"));
            if (skipRolesByRegexElemet != null) {
                this.skipRolesByRegex = skipRolesByRegexElemet.getText();
            }
        }
        catch (OMException e) {
            log.error((Object)"Error occurred when retrieving skipRolesByRegex, hence using the default value", (Throwable)e);
        }
        if (indexingConfig.getFirstChildWithName(new QName("solrServerUrl")) != null) {
            this.solrServerUrl = indexingConfig.getFirstChildWithName(new QName("solrServerUrl")).getText();
        }
        this.batchSize = Long.parseLong(indexingConfig.getFirstChildWithName(new QName("batchSize")).getText());
        this.indexerPoolSize = Integer.parseInt(indexingConfig.getFirstChildWithName(new QName("indexerPoolSize")).getText());
        Iterator exclusions = indexingConfig.getFirstChildWithName(new QName("exclusions")).getChildrenWithName(new QName("exclusion"));
        while (exclusions.hasNext()) {
            OMElement indexerEl = (OMElement)exclusions.next();
            String pathRegEx = indexerEl.getAttribute(new QName("pathRegEx")).getAttributeValue();
            if (pathRegEx == null) continue;
            try {
                this.exclusionList.add(Pattern.compile(pathRegEx));
            }
            catch (PatternSyntaxException ignore) {
                log.error((Object)("Error occured when compiling the RegEx pattern: " + pathRegEx), (Throwable)ignore);
            }
        }
        Iterator indexers = indexingConfig.getFirstChildWithName(new QName("indexers")).getChildrenWithName(new QName("indexer"));
        String currentProfile = System.getProperty("profile", "default");
        while (indexers.hasNext()) {
            OMElement indexerEl = (OMElement)indexers.next();
            boolean isValidConfigurationForProfile = false;
            String profileStr = indexerEl.getAttributeValue(new QName("profiles"));
            if (profileStr != null) {
                String[] profiles;
                for (String profile : profiles = profileStr.split(",")) {
                    if (!profile.trim().equals(currentProfile)) continue;
                    isValidConfigurationForProfile = true;
                }
            } else {
                isValidConfigurationForProfile = true;
            }
            if (!isValidConfigurationForProfile) continue;
            String clazz = indexerEl.getAttribute(new QName("class")).getAttributeValue();
            try {
                Object indexerObj = this.getClass().getClassLoader().loadClass(clazz).newInstance();
                if (!(indexerObj instanceof Indexer)) {
                    log.error((Object)(clazz + " has not implemented Indexer interface"));
                }
                String mediaPattern = indexerEl.getAttribute(new QName("mediaTypeRegEx")).getAttributeValue();
                this.indexerMap.put(mediaPattern, (Indexer)indexerObj);
            }
            catch (InstantiationException e) {
                log.error((Object)(clazz + " cannot be instantiated."), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)(clazz + " constructor cannot be accessed"), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)(clazz + " is not found in classpath. Please check whether the class is exported in your OSGI bundle."), (Throwable)e);
            }
        }
    }
}

