/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static RegistryService registryService;
    private static List<WaitBeforeShutdownObserver> waitBeforeShutdownObserver;
    private static String defaultEventingServiceURL;
    private static String remoteTopicHeaderName;
    private static String remoteTopicHeaderNS;
    private static String remoteSubscriptionStoreContext;

    public static void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static WaitBeforeShutdownObserver[] getWaitBeforeShutdownObservers() {
        return waitBeforeShutdownObserver.toArray(new WaitBeforeShutdownObserver[waitBeforeShutdownObserver.size()]);
    }

    public static void setWaitBeforeShutdownObserver(WaitBeforeShutdownObserver service) {
        CarbonUtils.checkSecurity();
        waitBeforeShutdownObserver.add(service);
    }

    public static void clearWaitBeforeShutdownObserver() {
        CarbonUtils.checkSecurity();
        waitBeforeShutdownObserver = new LinkedList<WaitBeforeShutdownObserver>();
    }

    public static Registry getRegistry() throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        Registry registry = (Registry)request.getSession().getAttribute("user_registry");
        if (registry == null) {
            String msg = "User's Registry instance is not found. Creating a anonymous Registry instance for the user.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (registryService == null) {
                msg = "Unable to create anonymous Registry instance for user. Registry Service was not found.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            registry = registryService.getUserRegistry();
            request.getSession().setAttribute("user_registry", (Object)registry);
        }
        return registry;
    }

    public static String getDefaultEventingServiceURL() {
        return defaultEventingServiceURL;
    }

    public static void setDefaultEventingServiceURL(String defaultEventingServiceURL) {
        Utils.defaultEventingServiceURL = defaultEventingServiceURL;
    }

    public static String getRemoteTopicHeaderName() {
        return remoteTopicHeaderName;
    }

    public static void setRemoteTopicHeaderName(String remoteTopicHeaderName) {
        Utils.remoteTopicHeaderName = remoteTopicHeaderName;
    }

    public static String getRemoteTopicHeaderNS() {
        return remoteTopicHeaderNS;
    }

    public static void setRemoteTopicHeaderNS(String remoteTopicHeaderNS) {
        Utils.remoteTopicHeaderNS = remoteTopicHeaderNS;
    }

    public static String getRemoteSubscriptionStoreContext() {
        return remoteSubscriptionStoreContext;
    }

    public static void setRemoteSubscriptionStoreContext(String remoteSubscriptionStoreContext) {
        Utils.remoteSubscriptionStoreContext = remoteSubscriptionStoreContext;
    }

    public static boolean isIndexingConfigAvailable() throws RegistryException {
        FileInputStream fileInputStream;
        String configPath = CarbonUtils.getRegistryXMLPath();
        File registryXML = new File(configPath);
        try {
            fileInputStream = new FileInputStream(registryXML);
        }
        catch (FileNotFoundException e) {
            String msg = "Registry configuration file (registry.xml) file doesn't exist in the path " + configPath;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
        try {
            StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)fileInputStream));
            OMElement configElement = builder.getDocumentElement();
            if (configElement != null) {
                OMElement indexingConfig = configElement.getFirstChildWithName(new QName("indexingConfiguration"));
                return indexingConfig != null;
            }
        }
        catch (XMLStreamException e) {
            String msg = "Failed to read <indexingConfiguration/> from registry.xml";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
        catch (CarbonException e) {
            String msg = "Failed to read <indexingConfiguration/> from registry.xml";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
        return false;
    }

    static {
        waitBeforeShutdownObserver = new LinkedList<WaitBeforeShutdownObserver>();
    }
}

