/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TermData;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.ContentBasedSearchService;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;
import org.wso2.carbon.registry.indexing.service.TenantIndexingLoader;
import org.wso2.carbon.registry.indexing.service.TermsQuerySearchService;
import org.wso2.carbon.registry.indexing.service.TermsSearchService;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

@Component(name="org.wso2.carbon.registry.indexing", immediate=true)
public class IndexingServiceComponent {
    private static Log log = LogFactory.getLog(IndexingServiceComponent.class);
    private static Stack<ServiceRegistration> registrations = new Stack();
    private static Map<Integer, Boolean> initializedTenants = new HashMap<Integer, Boolean>();

    @Activate
    protected void activate(ComponentContext context) {
        registrations.push(context.getBundleContext().registerService(ContentSearchService.class.getName(), (Object)new ContentSearchServiceImpl(), null));
        registrations.push(context.getBundleContext().registerService(AttributeSearchService.class.getName(), (Object)new AttributeSearchServiceImpl(), null));
        registrations.push(context.getBundleContext().registerService(TermsSearchService.class.getName(), (Object)new TermsSearchServiceImpl(), null));
        registrations.push(context.getBundleContext().registerService(TermsQuerySearchService.class.getName(), (Object)new TermsQuerySearchServiceImpl(), null));
        registrations.push(context.getBundleContext().registerService(WaitBeforeShutdownObserver.class.getName(), (Object)new WaitBeforeShutdownObserver(){
            boolean status = false;

            public void startingShutdown() {
                try {
                    IndexingManager.getInstance().stopIndexing();
                }
                finally {
                    this.status = true;
                }
            }

            public boolean isTaskComplete() {
                return this.status;
            }
        }, null));
        TenantDeploymentListenerImpl listener = new TenantDeploymentListenerImpl();
        registrations.push(context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)listener, null));
        registrations.push(context.getBundleContext().registerService(TenantIndexingLoader.class.getName(), (Object)listener, null));
        try {
            if (Utils.isIndexingConfigAvailable()) {
                IndexingManager.getInstance().startIndexing();
            } else {
                log.debug((Object)"<indexingConfiguration/> not available in registry.xml to start the resource indexing task");
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to start resource indexing task");
        }
        log.debug((Object)"Registry Indexing bundle is activated");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        while (!registrations.empty()) {
            registrations.pop().unregister();
        }
        log.debug((Object)"Registry Indexing bundle is deactivated");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.stopIndexing();
        Utils.setRegistryService(null);
    }

    private void stopIndexing() {
        IndexingManager.getInstance().stopIndexing();
    }

    public static Boolean isTenantIndexLoadedFromLogin(int tenantId) {
        return initializedTenants.get(tenantId);
    }

    public static void unloadTenantIndex(int tenantId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing tenant: " + tenantId));
        }
        if (initializedTenants.remove(tenantId) != null && log.isDebugEnabled()) {
            log.debug((Object)("Size of initializedTenants after removing tenant " + tenantId + ": " + initializedTenants.size()));
        }
    }

    public static boolean canIndexTenant(int tenantId) {
        return tenantId == -1234 || initializedTenants.containsKey(tenantId);
    }

    private static class TenantDeploymentListenerImpl
    extends AbstractAxis2ConfigurationContextObserver
    implements TenantIndexingLoader {
        private TenantDeploymentListenerImpl() {
        }

        public void createdConfigurationContext(ConfigurationContext configurationContext) {
            this.loadTenantIndex(MultitenantUtils.getTenantId((ConfigurationContext)configurationContext), true);
        }

        public void terminatingConfigurationContext(ConfigurationContext configContext) {
            IndexingServiceComponent.unloadTenantIndex(MultitenantUtils.getTenantId((ConfigurationContext)configContext));
        }

        private synchronized void loadTenantIndex(int tenantId, boolean isTenantLoaded) {
            if (IndexingServiceComponent.isTenantIndexLoadedFromLogin(tenantId) == null || !IndexingServiceComponent.isTenantIndexLoadedFromLogin(tenantId).booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding tenant: " + tenantId + ", isTenantLoaded: " + isTenantLoaded));
                }
                initializedTenants.put(tenantId, isTenantLoaded);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Size of initializedTenants after adding tenant " + tenantId + ": " + initializedTenants.size()));
                }
            }
        }

        @Override
        public void loadTenantIndex(int tenantId) {
            this.loadTenantIndex(tenantId, false);
        }
    }

    private static class TermsQuerySearchServiceImpl
    implements TermsQuerySearchService {
        private TermsQuerySearchServiceImpl() {
        }

        @Override
        public TermData[] search(UserRegistry registry, String query, String facetField) throws RegistryException {
            SearchResultsBean resultsBean;
            try {
                resultsBean = new ContentBasedSearchService().searchTermsByQuery(query, facetField, registry);
            }
            catch (IndexerException e) {
                throw new RegistryException("Unable to obtain an instance of a Solr client", (Throwable)e);
            }
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getTermDataList();
        }

        @Override
        public TermData[] search(int tenantId, String query, String facetField) throws RegistryException {
            return this.search(Utils.getRegistryService().getRegistry("wso2.system.user", tenantId), query, facetField);
        }

        @Override
        public TermData[] search(String query, String facetField) throws RegistryException {
            int tenantId;
            try {
                tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
            catch (Exception ignored) {
                tenantId = -1234;
            }
            if (tenantId == -1) {
                tenantId = -1234;
            }
            return this.search(tenantId, query, facetField);
        }
    }

    private static class TermsSearchServiceImpl
    implements TermsSearchService {
        private TermsSearchServiceImpl() {
        }

        public TermData[] search(UserRegistry registry, Map<String, String> query) throws RegistryException {
            SearchResultsBean resultsBean;
            try {
                resultsBean = new ContentBasedSearchService().searchTerms(query, registry);
            }
            catch (IndexerException e) {
                throw new RegistryException("Unable to obtain an instance of a Solr client", (Throwable)e);
            }
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getTermDataList();
        }

        public TermData[] search(int tenantId, Map<String, String> query) throws RegistryException {
            return this.search(Utils.getRegistryService().getRegistry("wso2.system.user", tenantId), query);
        }

        public TermData[] search(Map<String, String> query) throws RegistryException {
            int tenantId;
            try {
                tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
            catch (Exception ignored) {
                tenantId = -1234;
            }
            if (tenantId == -1) {
                tenantId = -1234;
            }
            return this.search(tenantId, query);
        }
    }

    private static class AttributeSearchServiceImpl
    implements AttributeSearchService {
        private AttributeSearchServiceImpl() {
        }

        public ResourceData[] search(UserRegistry registry, Map<String, String> query) throws RegistryException {
            SearchResultsBean resultsBean;
            try {
                resultsBean = new ContentBasedSearchService().searchByAttribute(query, registry);
            }
            catch (IndexerException e) {
                throw new RegistryException("Unable to obtain an instance of a Solr client", (Throwable)e);
            }
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getResourceDataList();
        }

        public ResourceData[] search(int tenantId, Map<String, String> query) throws RegistryException {
            return this.search(Utils.getRegistryService().getRegistry("wso2.system.user", tenantId), query);
        }

        public ResourceData[] search(Map<String, String> query) throws RegistryException {
            int tenantId;
            try {
                tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
            catch (Exception ignored) {
                tenantId = -1234;
            }
            if (tenantId == -1) {
                tenantId = -1234;
            }
            return this.search(tenantId, query);
        }
    }

    private static class ContentSearchServiceImpl
    implements ContentSearchService {
        private ContentSearchServiceImpl() {
        }

        public ResourceData[] search(UserRegistry registry, String query) throws RegistryException {
            SearchResultsBean resultsBean;
            try {
                resultsBean = new ContentBasedSearchService().searchContent(query, registry);
            }
            catch (IndexerException e) {
                throw new RegistryException("Unable to obtain an instance of a Solr client", (Throwable)e);
            }
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getResourceDataList();
        }

        public ResourceData[] search(int tenantId, String query) throws RegistryException {
            return this.search(Utils.getRegistryService().getRegistry("wso2.system.user", tenantId), query);
        }

        public ResourceData[] search(String query) throws RegistryException {
            return this.search(-1234, query);
        }
    }
}

