/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.service.Utils;

@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class AdvancedResourceQuery {
    private static Log log = LogFactory.getLog(AdvancedResourceQuery.class);
    private String resourceName;
    private String authorName;
    private String updaterName;
    private Date createdAfter;
    private Date createdBefore;
    private Date updatedAfter;
    private Date updatedBefore;
    private String commentWords;
    private String propertyName;
    private String propertyValue;
    private String content;
    private Set<String> tags;
    private String queryPath;

    public Resource execute(Registry registry) throws RegistryException {
        int i;
        String queryPath = this.computeQueryPathPrefix();
        if (queryPath.indexOf("1") == -1 && queryPath.indexOf("T") == -1) {
            String msg = "No parameters are specified for the query.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String queryResourceContent = this.generateSQLForResources();
        String[] resourcePaths = this.executeResourceQuery(registry, queryResourceContent);
        String queryCollectionContent = this.generateSQLForCollections();
        String[] collectionPaths = this.executeCollectionQuery(registry, queryCollectionContent);
        ArrayList<String> totalPathsArr = new ArrayList<String>();
        HashMap<String, Integer> resourceKeyHash = new HashMap<String, Integer>();
        for (i = 0; i < resourcePaths.length; ++i) {
            totalPathsArr.add(resourcePaths[i]);
            resourceKeyHash.put(resourcePaths[i], 1);
        }
        for (i = 0; i < collectionPaths.length; ++i) {
            if (resourceKeyHash.containsKey(collectionPaths[i])) continue;
            totalPathsArr.add(collectionPaths[i]);
        }
        String[] totalPaths = totalPathsArr.toArray(new String[totalPathsArr.size()]);
        Collection c = registry.newCollection();
        c.setContent((Object)totalPaths);
        return c;
    }

    private String[] executeResourceQuery(Registry registry, String query) throws RegistryException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            params.add(this.resourceName);
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            params.add(this.authorName);
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            params.add(this.updaterName);
        }
        if (this.createdAfter != null) {
            params.add(new Timestamp(this.createdAfter.getTime()));
        }
        if (this.createdBefore != null) {
            params.add(new Timestamp(this.createdBefore.getTime()));
        }
        if (this.updatedAfter != null) {
            params.add(new Timestamp(this.updatedAfter.getTime()));
        }
        if (this.updatedBefore != null) {
            params.add(new Timestamp(this.updatedBefore.getTime()));
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            params.add("%" + this.commentWords + "%");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            params.addAll(this.tags);
        }
        if (this.propertyName != null) {
            params.add(this.propertyName);
        }
        if (this.propertyValue != null) {
            params.add(this.propertyValue);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int i = 0; i < params.size(); ++i) {
            Object value = params.get(i);
            paramMap.put(Integer.toString(i + 1), value);
        }
        if (this.content != null) {
            paramMap.put("content", this.content);
        }
        paramMap.put("query", query);
        Collection r = registry.executeQuery(null, paramMap);
        return (String[])r.getContent();
    }

    private String[] executeCollectionQuery(Registry registry, String query) throws RegistryException {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            params.add("%/" + this.resourceName);
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            params.add(this.authorName);
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            params.add(this.updaterName);
        }
        if (this.createdAfter != null) {
            params.add(new Timestamp(this.createdAfter.getTime()));
        }
        if (this.createdBefore != null) {
            params.add(new Timestamp(this.createdBefore.getTime()));
        }
        if (this.updatedAfter != null) {
            params.add(new Timestamp(this.updatedAfter.getTime()));
        }
        if (this.updatedBefore != null) {
            params.add(new Timestamp(this.updatedBefore.getTime()));
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            params.add("%" + this.commentWords + "%");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            params.addAll(this.tags);
        }
        if (this.propertyName != null) {
            params.add(this.propertyName);
        }
        if (this.propertyValue != null) {
            params.add(this.propertyValue);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int i = 0; i < params.size(); ++i) {
            Object value = params.get(i);
            paramMap.put(Integer.toString(i + 1), value);
        }
        if (this.content != null) {
            paramMap.put("content", this.content);
        }
        paramMap.put("query", query);
        Collection r = registry.executeQuery(null, paramMap);
        return (String[])r.getContent();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        if ("".equals(resourceName)) {
            resourceName = null;
        }
        this.resourceName = resourceName;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        if ("".equals(authorName)) {
            authorName = null;
        }
        this.authorName = authorName;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public void setUpdaterName(String updaterName) {
        if ("".equals(updaterName)) {
            updaterName = null;
        }
        this.updaterName = updaterName;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public void setTags(String tags) {
        this.tags = this.parseTags(tags);
    }

    public void setPropertyName(String propertyName) {
        if ("".equals(propertyName)) {
            propertyName = null;
        }
        this.propertyName = propertyName;
    }

    public void setPropertyValue(String propertyValue) {
        if ("".equals(propertyValue)) {
            propertyValue = null;
        }
        this.propertyValue = propertyValue;
    }

    public String getCommentWords() {
        return this.commentWords;
    }

    public void setCommentWords(String commentWords) {
        if ("".equals(commentWords)) {
            commentWords = null;
        }
        this.commentWords = commentWords;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    private boolean queryExists(String queryPath) throws RegistryException {
        UserRegistry registry = (UserRegistry)Utils.getRegistry();
        return registry.resourceExists(queryPath);
    }

    private void defineQueries(String queryPath, String queryContent) throws RegistryException {
        UserRegistry registry = (UserRegistry)Utils.getRegistry();
        Resource q1 = registry.newResource();
        q1.setContent((Object)queryContent);
        q1.setMediaType("application/vnd.sql.query");
        q1.addProperty("resultType", "Resource");
        registry.put(queryPath, q1);
    }

    private String computeQueryPathPrefix() {
        if (this.queryPath == null) {
            StringBuffer buf = new StringBuffer("/system/queries/advanced");
            buf.append(this.resourceName != null ? "1" : "0");
            buf.append(this.authorName != null ? "1" : "0");
            buf.append(this.updaterName != null ? "1" : "0");
            buf.append(this.createdAfter != null ? "1" : "0");
            buf.append(this.createdBefore != null ? "1" : "0");
            buf.append(this.updatedAfter != null ? "1" : "0");
            buf.append(this.updatedBefore != null ? "1" : "0");
            buf.append(this.commentWords != null ? "1" : "0");
            buf.append(this.propertyName != null ? "1" : "0");
            buf.append(this.propertyValue != null ? "1" : "0");
            if (this.tags != null) {
                buf.append("T");
                buf.append(this.tags.size());
            }
            this.queryPath = buf.toString();
        }
        return this.queryPath;
    }

    public Set<String> parseTags(String tags) {
        String[] parts;
        HashSet<String> result = new HashSet<String>();
        if (tags == null) {
            return null;
        }
        for (String part1 : parts = tags.split(",")) {
            String part = part1.trim();
            if ("".equals(part)) continue;
            result.add(part);
        }
        return result;
    }

    private String generateSQLForResources() {
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            conditions.add("R.REG_NAME LIKE ?");
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            conditions.add("R.REG_CREATOR LIKE ?");
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            conditions.add("R.REG_LAST_UPDATOR LIKE ?");
        }
        if (this.createdAfter != null) {
            conditions.add("R.REG_CREATED_TIME > ?");
        }
        if (this.createdBefore != null) {
            conditions.add("R.REG_CREATED_TIME < ?");
        }
        if (this.updatedAfter != null) {
            conditions.add("R.REG_LAST_UPDATED_TIME > ?");
        }
        if (this.updatedBefore != null) {
            conditions.add("R.REG_LAST_UPDATED_TIME < ?");
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            tables.add(", REG_COMMENT C");
            tables.add(", REG_RESOURCE_COMMENT RC");
            if (StaticConfiguration.isVersioningComments()) {
                conditions.add("R.REG_VERSION=RC.REG_VERSION AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            } else {
                conditions.add("R.REG_PATH_ID=RC.REG_PATH_ID AND ((R.REG_NAME = RC.REG_RESOURCE_NAME)) AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            }
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            tables.add(", REG_TAG T");
            tables.add(", REG_RESOURCE_TAG RT");
            StringBuffer tagClause = new StringBuffer();
            if (StaticConfiguration.isVersioningTags()) {
                tagClause.append("R.REG_VERSION=RT.REG_VERSION AND RT.REG_TAG_ID=T.REG_ID ");
            } else {
                tagClause.append("R.REG_PATH_ID=RT.REG_PATH_ID AND ((R.REG_NAME = RT.REG_RESOURCE_NAME)) AND RT.REG_TAG_ID=T.REG_ID ");
            }
            Iterator<Object> i = this.tags.iterator();
            int count = 0;
            while (i.hasNext()) {
                if (++count == 1) {
                    tagClause.append(" AND lower(T.REG_TAG_NAME)=lower(?)");
                } else {
                    tagClause.append(" OR lower(T.REG_TAG_NAME)=lower(?)");
                }
                i.next();
            }
            conditions.add(tagClause.toString());
        }
        if (this.propertyValue != null || this.propertyName != null) {
            tables.add(", REG_PROPERTY PP");
            tables.add(", REG_RESOURCE_PROPERTY RP");
            StringBuffer propertyClause = new StringBuffer();
            if (StaticConfiguration.isVersioningProperties()) {
                propertyClause.append("R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID");
            } else {
                propertyClause.append("R.REG_PATH_ID=RP.REG_PATH_ID AND ((R.REG_NAME = RP.REG_RESOURCE_NAME)) AND RP.REG_PROPERTY_ID=PP.REG_ID");
            }
            if (this.propertyName != null) {
                propertyClause.append(" AND lower(PP.REG_NAME)=lower(?)");
            }
            if (this.propertyValue != null) {
                propertyClause.append(" AND PP.REG_VALUE LIKE ?");
            }
            conditions.add(propertyClause.toString());
        }
        StringBuffer query = new StringBuffer();
        query.append("SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R");
        for (String table : tables) {
            query.append(table);
        }
        boolean first = true;
        for (String condition : conditions) {
            if (first) {
                query.append(" WHERE ");
                first = false;
            } else {
                query.append(" AND ");
            }
            query.append(condition);
        }
        return query.toString();
    }

    private String generateSQLForCollections() {
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("R.REG_NAME IS NULL");
        if (this.resourceName != null && this.resourceName.length() != 0) {
            tables.add(", REG_PATH P");
            conditions.add(" P.REG_PATH_VALUE LIKE ? AND P.REG_PATH_ID=R.REG_PATH_ID");
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            conditions.add("R.REG_CREATOR LIKE ?");
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            conditions.add("R.REG_LAST_UPDATOR LIKE ?");
        }
        if (this.createdAfter != null) {
            conditions.add("R.REG_CREATED_TIME > ?");
        }
        if (this.createdBefore != null) {
            conditions.add("R.REG_CREATED_TIME < ?");
        }
        if (this.updatedAfter != null) {
            conditions.add("R.REG_LAST_UPDATED_TIME > ?");
        }
        if (this.updatedBefore != null) {
            conditions.add("R.REG_LAST_UPDATED_TIME < ?");
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            tables.add(", REG_COMMENT C");
            tables.add(", REG_RESOURCE_COMMENT RC");
            if (StaticConfiguration.isVersioningComments()) {
                conditions.add("R.REG_VERSION=RC.REG_VERSION AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            } else {
                conditions.add("R.REG_PATH_ID=RC.REG_PATH_ID AND R.REG_NAME IS NULL AND RC.REG_RESOURCE_NAME IS NULL AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            }
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            tables.add(", REG_TAG T");
            tables.add(", REG_RESOURCE_TAG RT");
            StringBuffer tagClause = new StringBuffer();
            if (StaticConfiguration.isVersioningTags()) {
                tagClause.append("R.REG_VERSION=RT.REG_VERSION AND RT.REG_TAG_ID=T.REG_ID ");
            } else {
                tagClause.append("R.REG_PATH_ID=RT.REG_PATH_ID AND R.REG_NAME IS NULL AND RT.REG_RESOURCE_NAME IS NULL AND RT.REG_TAG_ID=T.REG_ID ");
            }
            Iterator<Object> i = this.tags.iterator();
            int count = 0;
            while (i.hasNext()) {
                if (++count == 1) {
                    tagClause.append(" AND lower(T.REG_TAG_NAME)=lower(?)");
                } else {
                    tagClause.append(" OR lower(T.REG_TAG_NAME)=lower(?)");
                }
                i.next();
            }
            conditions.add(tagClause.toString());
        }
        if (this.propertyValue != null || this.propertyName != null) {
            tables.add(", REG_PROPERTY PP");
            tables.add(", REG_RESOURCE_PROPERTY RP");
            StringBuffer propertyClause = new StringBuffer();
            if (StaticConfiguration.isVersioningProperties()) {
                propertyClause.append("R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID");
            } else {
                propertyClause.append("R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL AND RP.REG_PROPERTY_ID=PP.REG_ID");
            }
            if (this.propertyName != null) {
                propertyClause.append(" AND lower(PP.REG_NAME)=lower(?)");
            }
            if (this.propertyValue != null) {
                propertyClause.append(" AND PP.REG_VALUE LIKE ?");
            }
            conditions.add(propertyClause.toString());
        }
        if (conditions.size() == 0) {
            return null;
        }
        StringBuffer query = new StringBuffer();
        query.append("SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R");
        for (String table : tables) {
            query.append(table);
        }
        boolean first = true;
        for (String condition : conditions) {
            if (first) {
                query.append(" WHERE ");
                first = false;
            } else {
                query.append(" AND ");
            }
            query.append(condition);
        }
        return query.toString();
    }
}

