/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.utils.RxtUnboundedDataLoadUtils;

public class RxtUnboundedFieldManagerService
extends AbstractAdmin {
    private static RxtUnboundedFieldManagerService rxtUnboundedFieldManagerServiceInstance = new RxtUnboundedFieldManagerService();
    private static Map<Integer, Map<String, List<String>>> allTenantsUnboundedFields = new ConcurrentHashMap<Integer, Map<String, List<String>>>();

    public static RxtUnboundedFieldManagerService getInstance() {
        return rxtUnboundedFieldManagerServiceInstance;
    }

    public Map<Integer, Map<String, List<String>>> getTenantsUnboundedFields() {
        return allTenantsUnboundedFields;
    }

    public void setActiveTenantsUnboundedFields(String rxtConfig) throws RegistryException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        UserRegistry registry = Utils.getRegistryService().getRegistry();
        Map<String, List<String>> tenantRxtUnboundedEntries = RxtUnboundedDataLoadUtils.getRxtData(registry);
        allTenantsUnboundedFields.put(tenantId, tenantRxtUnboundedEntries);
    }

    public void setTenantsUnboundedFields(Integer tenantId, Map<String, List<String>> rxtUnboundedFiledMap) {
        allTenantsUnboundedFields.put(tenantId, rxtUnboundedFiledMap);
    }
}

