/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.solr;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.RegistryConfigLoader;
import org.wso2.carbon.registry.indexing.SolrConstants;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.RxtUnboundedFieldManagerService;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.CarbonUtils;

public class SolrClient {
    public static final Log log = LogFactory.getLog(SolrClient.class);
    private static volatile SolrClient instance;
    private org.apache.solr.client.solrj.SolrClient server;
    private Map<String, String> filePathMap = new HashMap<String, String>();
    private static final String SOLR_HOME_FILE_PATH;
    private File solrHome;
    private File confDir;
    private File langDir;
    private String solrCore = null;
    private String skipRolesByRegex;

    protected SolrClient() throws IOException {
        RegistryConfigLoader configLoader = RegistryConfigLoader.getInstance();
        String solrServerUrl = configLoader.getSolrServerUrl();
        this.skipRolesByRegex = configLoader.getSkipRolesByRegex();
        this.solrCore = "registry-indexing";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Solr server core is set as: " + this.solrCore));
        }
        this.solrHome = new File(SOLR_HOME_FILE_PATH);
        if (!this.solrHome.exists() && !this.solrHome.mkdirs()) {
            throw new IOException("Solr home directory could not be created. path: " + this.solrHome);
        }
        this.confDir = new File(this.solrHome, this.solrCore + File.separator + "conf");
        if (!this.confDir.exists() && !this.confDir.mkdirs()) {
            throw new IOException("Solr conf directory could not be created! Path: " + this.confDir);
        }
        this.langDir = new File(this.confDir, "lang");
        if (!this.langDir.exists() && !this.langDir.mkdirs()) {
            throw new IOException("Solr lang directory could not be created! Path: " + this.langDir);
        }
        this.readConfigurationFilePaths();
        this.copyConfigurationFiles();
        System.setProperty("solr.solr.home", this.solrHome.getPath());
        if (solrServerUrl != null && !solrServerUrl.isEmpty()) {
            HttpSolrClient.Builder builder = new HttpSolrClient.Builder(solrServerUrl);
            this.server = builder.build();
            log.info((Object)("Http Solr server initiated at: " + solrServerUrl));
        } else {
            NodeConfig nodeConfig = new NodeConfig.NodeConfigBuilder("registry-indexing", Paths.get(this.solrHome.getPath(), new String[0])).build();
            CoreContainer coreContainer = new CoreContainer(nodeConfig);
            coreContainer.load();
            this.server = new EmbeddedSolrServer(coreContainer, this.solrCore);
            log.info((Object)"Default Embedded Solr Server Initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SolrClient getInstance() throws IndexerException {
        if (instance != null) return instance;
        Class<SolrClient> clazz = SolrClient.class;
        synchronized (SolrClient.class) {
            if (instance != null) return instance;
            try {
                instance = new SolrClient();
            }
            catch (IOException e) {
                log.error((Object)"Could not instantiate Solr client", (Throwable)e);
                throw new IndexerException("Could not instantiate Solr client", e);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigurationFilePaths() throws IOException {
        try (InputStream resourceAsStream = null;){
            resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("solr_configuration_files.properties");
            Properties fileProperties = new Properties();
            fileProperties.load(resourceAsStream);
            for (Map.Entry<Object, Object> entry : fileProperties.entrySet()) {
                String[] fileNames;
                if (entry.getValue() == null) continue;
                for (String fileName : fileNames = entry.getValue().toString().split(",")) {
                    this.filePathMap.put(fileName, (String)entry.getKey());
                }
            }
        }
    }

    private void copyConfigurationFiles() throws IOException {
        for (Map.Entry<String, String> entry : this.filePathMap.entrySet()) {
            String sourceFileName = entry.getKey();
            String fileDestinationPath = entry.getValue();
            File file = "home/".equals(fileDestinationPath) ? new File(this.solrHome, sourceFileName) : ("home/core/".equals(fileDestinationPath) ? new File(this.confDir.getParentFile(), sourceFileName) : ("home/core/conf/lang".equals(fileDestinationPath) ? new File(this.langDir, sourceFileName) : new File(this.confDir, sourceFileName)));
            if (file.exists()) continue;
            this.write2File(sourceFileName, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2File(String sourceFileName, File dest) throws IOException {
        byte[] buf = new byte[1024];
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(sourceFileName);
            out = new FileOutputStream(dest);
            if ("core.properties".equals(sourceFileName)) {
                Properties coreProperties = new Properties();
                coreProperties.load(in);
                coreProperties.setProperty("name", this.solrCore);
                coreProperties.store(out, null);
            } else {
                int read;
                while ((read = in.read(buf)) >= 0) {
                    out.write(buf, 0, read);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public synchronized void deleteIndexByQuery(String query) throws SolrException {
        try {
            this.server.deleteByQuery(query);
            this.server.commit();
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at deleting", (Throwable)e);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at deleting", (Throwable)e);
        }
    }

    private String generateId(int tenantId, String path) {
        return path + "tenantId" + tenantId;
    }

    public void addDocument(IndexDocument indexDoc) throws SolrException {
        try {
            String path = indexDoc.getPath();
            String rawContent = indexDoc.getRawContent();
            String contentAsText = indexDoc.getContentAsText();
            int tenantId = indexDoc.getTenantId();
            Map<String, List<String>> fields = indexDoc.getFields();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Indexing Document in resource path: " + path));
            }
            SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
            this.addFieldID(tenantId, path, rawContent, solrInputDocument);
            this.addRawContent(rawContent, solrInputDocument);
            this.addTenantId(tenantId, solrInputDocument);
            this.addContentAsText(contentAsText, solrInputDocument);
            this.addDynamicFields(fields, solrInputDocument);
            this.server.add(solrInputDocument);
            if (log.isDebugEnabled()) {
                Gson gson = new Gson();
                String json = gson.toJson((Object)solrInputDocument);
                log.debug((Object)("Indexing document content: " + json));
            }
        }
        catch (SolrServerException e) {
            String message = "Error at indexing.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message, (Throwable)e);
        }
        catch (IOException e) {
            String message = "Error at indexing.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message, (Throwable)e);
        }
    }

    private void addDynamicFields(Map<String, List<String>> fields, SolrInputDocument solrInputDocument) {
        if (fields != null && fields.size() > 0) {
            for (Map.Entry<String, List<String>> fieldList : fields.entrySet()) {
                String fieldKey;
                if (fieldList.getKey().equals("propertyValues") || fieldList.getKey().equals("associationDest") || fieldList.getKey().equals("associationType") || fieldList.getKey().equals("commentWords") || fieldList.getKey().equals("taxonomy") || fieldList.getKey().equals("tags")) {
                    if (fieldList.getKey().equals("propertyValues")) {
                        for (String value : fieldList.getValue()) {
                            String[] propertyValArray = value.split(",");
                            fieldKey = propertyValArray[0];
                            String[] propValues = Arrays.copyOfRange(propertyValArray, 1, propertyValArray.length);
                            if (propValues.length <= 0) continue;
                            this.addPropertyField(fieldKey, propValues, solrInputDocument);
                        }
                        continue;
                    }
                    fieldKey = fieldList.getKey() + "_ss";
                    for (String value : fieldList.getValue()) {
                        solrInputDocument.addField(fieldKey, (Object)value);
                    }
                    continue;
                }
                if ("allowedRoles".equals(fieldList.getKey())) {
                    for (String value : fieldList.getValue()) {
                        solrInputDocument.addField("allowedRoles", (Object)value);
                    }
                    continue;
                }
                if (fieldList.getKey().equals("createdDate") || fieldList.getKey().equals("lastUpdatedDate")) {
                    fieldKey = fieldList.getKey() + "_dt";
                    String date = this.toSolrDateFormat(fieldList.getValue().get(0), "EEE MMM d HH:mm:ss z yyyy");
                    if (date == null) continue;
                    solrInputDocument.addField(fieldKey, (Object)date);
                    continue;
                }
                String fieldKeyValue = fieldList.getKey().equals("resourceName") ? "resourceName" : fieldList.getKey();
                String mediaType = null;
                List<String> mediaTypeArray = fields.get("mediaType");
                if (mediaTypeArray != null && mediaTypeArray.size() > 0) {
                    mediaType = mediaTypeArray.get(0);
                }
                if (fieldList.getValue() != null && mediaType != null && this.isMultiValueField(mediaType, fieldList.getKey())) {
                    solrInputDocument.addField(fieldKeyValue + "_ss", fieldList.getValue());
                    continue;
                }
                solrInputDocument.addField(fieldKeyValue + "_s", (Object)fieldList.getValue().get(0));
            }
        }
    }

    private void addPropertyField(String fieldKey, String[] values, SolrInputDocument solrInputDocument) {
        String valueType = this.getType(values[0]);
        block14: for (String propValue : values) {
            switch (valueType) {
                case "int": {
                    try {
                        int intValue = Integer.parseInt(propValue);
                        solrInputDocument.addField(fieldKey + "_is", (Object)intValue);
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("Number format error when parsing the value, Hence indexing as string value. Field: " + fieldKey));
                        solrInputDocument.addField(fieldKey + "_ss", (Object)propValue);
                    }
                    continue block14;
                }
                case "double": {
                    try {
                        double doubleValue = Double.parseDouble(propValue);
                        solrInputDocument.addField(fieldKey + "_ds", (Object)doubleValue);
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("Number format error when parsing the value, Hence indexing as string value. Field: " + fieldKey));
                        solrInputDocument.addField(fieldKey + "_ss", (Object)propValue);
                    }
                    continue block14;
                }
                case "string": {
                    solrInputDocument.addField(fieldKey + "_ss", (Object)propValue);
                }
            }
        }
    }

    private String getType(String value) {
        Matcher intMatcher = SolrConstants.INT_PATTERN.matcher(value);
        Matcher doubleMatcher = SolrConstants.DOUBLE_PATTERN.matcher(value);
        String type = intMatcher.matches() ? "int" : (doubleMatcher.matches() ? "double" : "string");
        return type;
    }

    private void addContentAsText(String contentAsText, SolrInputDocument solrInputDocument) {
        if (contentAsText != null && contentAsText.length() > 0) {
            solrInputDocument.addField("contentOnly", (Object)contentAsText);
        }
    }

    private void addTenantId(int tenantId, SolrInputDocument solrInputDocument) {
        solrInputDocument.addField("tenantId", (Object)String.valueOf(tenantId));
    }

    private void addRawContent(String rawContent, SolrInputDocument solrInputDocument) {
        if (rawContent != null && StringUtils.isNotEmpty((String)rawContent)) {
            solrInputDocument.addField("text", (Object)rawContent);
        }
    }

    private void addFieldID(int tenantId, String path, String rawContent, SolrInputDocument solrInputDocument) {
        String id = this.generateId(tenantId, path);
        if (id == null) {
            id = "id" + rawContent.hashCode();
        }
        solrInputDocument.addField("id", (Object)id);
    }

    private String toSolrDateFormat(String dateStr, String currentFormat) {
        String solrDateFormatResult = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(currentFormat, Locale.ENGLISH);
            Date date = sdf.parse(dateStr);
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            solrDateFormatResult = sdf.format(date);
        }
        catch (ParseException e) {
            log.error((Object)("Error when passing date to create solr date format." + e));
        }
        return solrDateFormatResult;
    }

    public void indexDocument(AsyncIndexer.File2Index fileData, Indexer indexer) throws RegistryException {
        IndexDocument doc = indexer.getIndexedDocument(fileData);
        doc.setTenantId(fileData.tenantId);
        this.addDocument(doc);
    }

    public synchronized void deleteFromIndex(String path, int tenantId) throws SolrException {
        try {
            String id = this.generateId(tenantId, path);
            this.server.deleteById(id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Solr delete index path: " + path + " id: " + id));
            }
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at deleting", (Throwable)e);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at deleting", (Throwable)e);
        }
    }

    public SolrDocumentList query(String keywords, int tenantId) throws SolrException {
        return this.query(keywords, tenantId, Collections.emptyMap());
    }

    public SolrDocumentList query(int tenantId, Map<String, String> fields) throws SolrException {
        return this.query("[* TO *]", tenantId, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SolrDocumentList query(String keywords, int tenantId, Map<String, String> fields) throws SolrException {
        try {
            QueryResponse queryresponse;
            SolrQuery query;
            String contentAttribute = fields.get("content");
            if (contentAttribute != null && StringUtils.isNotEmpty((String)contentAttribute)) {
                query = this.getCharCount(contentAttribute, '\"') > 0 ? new SolrQuery(contentAttribute) : new SolrQuery(contentAttribute.replaceAll(" ", " OR ").replaceAll("&&", " AND "));
                fields.remove("content");
            } else if (keywords.equals("[* TO *]")) {
                query = new SolrQuery("* TO *");
            } else {
                String solrQuery = this.convertFieldNames(keywords);
                query = new SolrQuery(solrQuery);
            }
            query.setRows(Integer.valueOf(Integer.MAX_VALUE));
            if (tenantId == -1234) {
                query.addFilterQuery(new String[]{"tenantId:\\" + tenantId});
            } else {
                query.addFilterQuery(new String[]{"tenantId:" + tenantId});
            }
            if (fields.get("mediaType") != null && (fields.get("mediaType").equals("application/policy+xml") || fields.get("mediaType").equals("application/wsdl+xml"))) {
                query.addFilterQuery(new String[]{"id:\\/_system\\/governance\\/*"});
            }
            this.addUserRoleFilter(tenantId, query);
            this.addQueryFilters(fields, query);
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            if (!(messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext) || PaginationContext.getInstance() != null)) {
                queryresponse = this.server.query((SolrParams)query);
                if (!log.isDebugEnabled()) return queryresponse.getResults();
                log.debug((Object)("Solr index queried query: " + query));
                return queryresponse.getResults();
            }
            try {
                PaginationContext paginationContext = messageContext != null ? PaginationUtils.initPaginationContext((MessageContext)messageContext) : PaginationContext.getInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Pagination Context| start: " + paginationContext.getStart() + " | rows:" + paginationContext.getCount() + " | sortBy: " + paginationContext.getSortBy()));
                }
                query.setStart(Integer.valueOf(paginationContext.getStart()));
                query.setRows(Integer.valueOf(paginationContext.getCount()));
                String sortBy = paginationContext.getSortBy();
                if ("meta_created_date".equals(sortBy)) {
                    sortBy = "createdDate";
                } else if ("meta_last_updated_date".equals(sortBy)) {
                    sortBy = "lastUpdatedDate";
                }
                if (sortBy.length() > 0) {
                    String sortOrder = paginationContext.getSortOrder();
                    this.addSortByQuery(query, sortBy, sortOrder);
                }
                queryresponse = this.server.query((SolrParams)query);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Solr index queried query: " + query));
                }
                if (messageContext != null) {
                    PaginationUtils.setRowCount((MessageContext)messageContext, (String)Long.toString(queryresponse.getResults().getNumFound()));
                    return queryresponse.getResults();
                }
                if (null != queryresponse.getResults()) {
                    paginationContext.setLength((int)queryresponse.getResults().getNumFound());
                    return queryresponse.getResults();
                }
                if (queryresponse.getGroupResponse() == null) return queryresponse.getResults();
                if (queryresponse.getGroupResponse().getValues().size() <= 0) return queryresponse.getResults();
                Iterator iterator = queryresponse.getGroupResponse().getValues().iterator();
                if (!iterator.hasNext()) return queryresponse.getResults();
                GroupCommand groupCmd = (GroupCommand)iterator.next();
                paginationContext.setLength(groupCmd.getNGroups().intValue());
                SolrDocumentList solrDocumentsList = new SolrDocumentList();
                for (Group group : groupCmd.getValues()) {
                    solrDocumentsList.addAll((Collection)group.getResult());
                }
                SolrDocumentList solrDocumentList = solrDocumentsList;
                return solrDocumentList;
            }
            finally {
                if (messageContext != null) {
                    PaginationContext.destroy();
                }
            }
        }
        catch (IOException | SolrServerException e) {
            String message = "Failure at query ";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message + keywords, e);
        }
    }

    private String convertFieldNames(String keywords) {
        Pattern p = Pattern.compile("([^-\\s -()]*?):");
        Matcher m = p.matcher(keywords);
        while (m.find()) {
            String fieldName = m.group(1);
            if ("tags".equals(fieldName) || "taxonomy".equals(fieldName) || "commentWords".equals(fieldName) || "associationDest".equals(fieldName) || "associationType".equals(fieldName)) {
                keywords = this.replaceKeyword(keywords, fieldName, "_ss");
                continue;
            }
            if ("createdDate".equals(fieldName) || "lastUpdatedDate".equals(fieldName)) {
                keywords = this.replaceKeyword(keywords, fieldName, "_dt");
                continue;
            }
            if ("lcName".equals(fieldName) || "lcState".equals(fieldName) || "author".equals(fieldName) || "mediaType".equals(fieldName) || "updater".equals(fieldName)) {
                keywords = this.replaceKeyword(keywords, fieldName, "_s");
                continue;
            }
            if ("content".equals(fieldName)) {
                keywords = keywords.replace("content:", "");
                continue;
            }
            if (!fieldName.contains("_")) {
                keywords = this.replaceKeyword(keywords, fieldName, "_ss");
                continue;
            }
            keywords = this.replaceKeyword(keywords, fieldName, "_s");
        }
        log.debug((Object)("Solr Query Search | Search Query:::: " + keywords));
        return keywords;
    }

    private String replaceKeyword(String keyword, String fieldName, String suffix) {
        int count = StringUtils.countMatches((String)keyword, (String)fieldName);
        if (count > 1) {
            keyword = keyword.replace(fieldName, fieldName + suffix);
            keyword = keyword.replace("overview_" + fieldName + suffix, "overview_" + fieldName);
        } else {
            keyword = keyword.replace(fieldName, fieldName + suffix);
        }
        return keyword;
    }

    private int getCharCount(String str, char key) {
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != key) continue;
            ++counter;
        }
        return counter;
    }

    private void addUserRoleFilter(int tenantId, SolrQuery query) throws SolrException {
        try {
            UserRegistry registry = Utils.getRegistryService().getRegistry("wso2.system.user", tenantId);
            UserRealm realm = registry.getUserRealm();
            String userName = SolrClient.getLoggedInUserName();
            if (userName == null) {
                userName = "wso2.anonymous.user";
            }
            String[] userRoles = realm.getUserStoreManager().getRoleListOfUser(userName);
            if (this.skipRolesByRegex != null) {
                ArrayList<String> filteredUserRoles = new ArrayList<String>(Arrays.asList(userRoles));
                String[] regexList = this.skipRolesByRegex.split(",");
                for (int i = 0; i < regexList.length; ++i) {
                    Pattern p = Pattern.compile(regexList[i]);
                    Iterator itr = filteredUserRoles.iterator();
                    while (itr.hasNext()) {
                        String role = (String)itr.next();
                        Matcher m = p.matcher(role);
                        if (!m.matches()) continue;
                        itr.remove();
                    }
                }
                userRoles = filteredUserRoles.toArray(new String[0]);
            }
            StringBuilder rolesQuery = new StringBuilder();
            for (String userRole : userRoles) {
                if (rolesQuery.length() == 0) {
                    rolesQuery.append('(');
                    rolesQuery.append(ClientUtils.escapeQueryChars((String)userRole.toLowerCase()));
                    continue;
                }
                rolesQuery.append(" OR ");
                rolesQuery.append(ClientUtils.escapeQueryChars((String)userRole.toLowerCase()));
            }
            rolesQuery.append(')');
            String queryValue = rolesQuery.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("user roles filter query values: " + queryValue));
            }
            query.addFilterQuery(new String[]{"allowedRoles:" + queryValue});
        }
        catch (RegistryException | UserStoreException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error while creating user role filter query", e);
        }
    }

    private void addSortByQuery(SolrQuery query, String sortBy, String sortOrder) {
        if ("tags".equals(sortBy) || "commentWords".equals(sortBy) || "associationDest".equals(sortBy) || "taxonomy".equals(sortBy) || "associationType".equals(sortBy)) {
            log.error((Object)"Sorting in multivalued fields is not supported");
        } else if ("createdDate".equals(sortBy) || "lastUpdatedDate".equals(sortBy)) {
            query.setSort(sortBy + "_dt", "ASC".equals(sortOrder) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        } else {
            query.setSort(sortBy + "_s", "ASC".equals(sortOrder) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
    }

    private void addGroupingQuery(SolrQuery query, String groupKey, String groupVal) {
        if ("group".equals(groupKey) || "group.field".equals(groupKey) || "group.sort".equals(groupKey) || "group.ngroups".equals(groupKey) || "group.format".equals(groupKey)) {
            query.set(groupKey, new String[]{groupVal});
        }
    }

    public List<FacetField.Count> facetQuery(String keywords, String facetField, int tenantId) throws SolrException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("facet.field", facetField);
        return this.facetQuery(keywords, tenantId, fields);
    }

    public List<FacetField.Count> facetQuery(int tenantId, Map<String, String> fields) throws SolrException {
        return this.facetQuery("[* TO *]", tenantId, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FacetField.Count> facetQuery(String keywords, int tenantId, Map<String, String> fields) throws SolrException {
        List<Object> fieldsList = new ArrayList<FacetField.Count>();
        String facetField = null;
        try {
            QueryResponse queryresponse;
            MessageContext messageContext;
            SolrQuery query;
            String contentAttribute = fields.get("content");
            if (contentAttribute != null && StringUtils.isNotEmpty((String)contentAttribute)) {
                query = this.getCharCount(contentAttribute, '\"') > 0 ? new SolrQuery(contentAttribute) : new SolrQuery(contentAttribute.replaceAll(" ", " OR ").replaceAll("&&", " AND "));
                fields.remove("content");
            } else if (keywords.equals("[* TO *]")) {
                query = new SolrQuery("* TO *");
            } else {
                String solrQuery = this.convertFieldNames(keywords);
                query = new SolrQuery(solrQuery);
            }
            query.setRows(Integer.valueOf(Integer.MAX_VALUE));
            if (tenantId == -1234) {
                query.addFilterQuery(new String[]{"tenantId:\\" + tenantId});
            } else {
                query.addFilterQuery(new String[]{"tenantId:" + tenantId});
            }
            if (fields.get("mediaType") != null && (fields.get("mediaType").equals("application/policy+xml") || fields.get("mediaType").equals("application/wsdl+xml"))) {
                query.addFilterQuery(new String[]{"id:\\/_system\\/governance\\/*"});
            }
            facetField = this.addFacetFields(fields, query);
            this.addUserRoleFilter(tenantId, query);
            this.addQueryFilters(fields, query);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Solr search faceted query: " + query));
            }
            if ((messageContext = MessageContext.getCurrentMessageContext()) != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext) || PaginationContext.getInstance() != null) {
                try {
                    PaginationContext paginationContext = messageContext != null ? PaginationUtils.initPaginationContext((MessageContext)messageContext) : PaginationContext.getInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Pagination Context| start: " + paginationContext.getStart() + " | rows:" + paginationContext.getCount() + " | sortBy: " + paginationContext.getSortBy()));
                    }
                    query.setStart(Integer.valueOf(paginationContext.getStart()));
                    query.setRows(Integer.valueOf(paginationContext.getCount()));
                    queryresponse = this.server.query((SolrParams)query);
                    if (messageContext != null) {
                        PaginationUtils.setRowCount((MessageContext)messageContext, (String)Long.toString(queryresponse.getResults().getNumFound()));
                    }
                    paginationContext.setLength((int)queryresponse.getResults().getNumFound());
                }
                finally {
                    if (messageContext != null) {
                        PaginationContext.destroy();
                    }
                }
            } else {
                queryresponse = this.server.query((SolrParams)query);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Solr index queried query: " + query));
                }
            }
            if (queryresponse.getFacetField(facetField) != null) {
                fieldsList = queryresponse.getFacetField(facetField).getValues();
            }
            return fieldsList;
        }
        catch (IOException | SolrServerException e) {
            String message = "Failure at query ";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message + facetField, e);
        }
    }

    private String addFacetFields(Map<String, String> fields, SolrQuery query) {
        query.setFacet(true);
        String fieldName = fields.get("facet.field");
        String queryField = null;
        if (fieldName != null) {
            if ("tags".equals(fieldName) || "taxonomy".equals(fieldName) || "commentWords".equals(fieldName) || "associationDest".equals(fieldName) || "associationType".equals(fieldName)) {
                queryField = fieldName + "_ss";
                query.addFacetField(new String[]{queryField});
            } else {
                queryField = fieldName + "_s";
                query.addFacetField(new String[]{queryField});
            }
            fields.remove("facet.field");
            if (fields.get("facet.limit") != null) {
                query.setFacetLimit(Integer.parseInt(fields.get("facet.limit")));
                fields.remove("facet.limit");
            } else {
                query.setFacetLimit(-1);
            }
            if (fields.get("facet.mincount") != null) {
                query.setFacetMinCount(Integer.parseInt(fields.get("facet.mincount")));
                fields.remove("facet.mincount");
            } else {
                query.setFacetMinCount(1);
            }
            if (fields.get("facet.sort") != null) {
                query.setFacetSort(fields.get("facet.sort"));
                fields.remove("facet.sort");
            }
            if (fields.get("facet.prefix") != null) {
                query.setFacetPrefix(fields.get("facet.prefix"));
                fields.remove("facet.prefix");
            }
        }
        return queryField;
    }

    private void addQueryFilters(Map<String, String> fields, SolrQuery query) {
        if (fields.size() > 0) {
            String fieldKey;
            String propertyName = "";
            String leftPropertyValue = "";
            String rightPropertyValue = "";
            String leftOp = "";
            String rightOp = "";
            String createdBefore = "";
            String createdAfter = "";
            String updatedBefore = "";
            String updatedAfter = "";
            String mediaType = "";
            String mediaTypeNegate = "";
            String createdBy = "";
            String createdByNegate = "";
            String updatedBy = "";
            String updatedByNegate = "";
            String createdRangeNegate = "";
            String updatedRangeNegate = "";
            String resourceName = "";
            String group = "";
            String groupNGroups = "";
            String groupField = "";
            String groupSort = "";
            String groupFormat = "";
            for (Map.Entry<String, String> field : fields.entrySet()) {
                String fieldKeySuffix;
                if (field.getValue() == null || !StringUtils.isNotEmpty((String)field.getValue())) continue;
                if (field.getKey().equals("tags") || field.getKey().equals("taxonomy") || field.getKey().equals("commentWords") || field.getKey().equals("associationDest") || field.getKey().equals("associationType")) {
                    fieldKeySuffix = "_ss:";
                    if ("associationDest".equals(field.getKey())) {
                        query.addFilterQuery(new String[]{field.getKey() + fieldKeySuffix + "\"" + field.getValue() + "\""});
                        continue;
                    }
                    query.addFilterQuery(new String[]{field.getKey() + fieldKeySuffix + field.getValue()});
                    continue;
                }
                if ("propertyName".equals(field.getKey())) {
                    propertyName = field.getValue();
                    continue;
                }
                if ("leftPropertyValue".equals(field.getKey())) {
                    leftPropertyValue = field.getValue();
                    continue;
                }
                if ("rightPropertyValue".equals(field.getKey())) {
                    rightPropertyValue = field.getValue();
                    continue;
                }
                if ("leftOp".equals(field.getKey())) {
                    leftOp = field.getValue();
                    continue;
                }
                if ("rightOp".equals(field.getKey())) {
                    rightOp = field.getValue();
                    continue;
                }
                if ("createdBefore".equals(field.getKey())) {
                    createdBefore = this.removeSpecialCharacters(field.getValue());
                    continue;
                }
                if ("createdAfter".equals(field.getKey())) {
                    createdAfter = this.removeSpecialCharacters(field.getValue());
                    continue;
                }
                if ("updatedBefore".equals(field.getKey())) {
                    updatedBefore = this.removeSpecialCharacters(field.getValue());
                    continue;
                }
                if ("updatedAfter".equals(field.getKey())) {
                    updatedAfter = this.removeSpecialCharacters(field.getValue());
                    continue;
                }
                if ("resourceName".equals(field.getKey())) {
                    resourceName = field.getValue();
                    if (!resourceName.contains(" ")) continue;
                    resourceName = "\"" + resourceName + "\"";
                    continue;
                }
                if ("mediaType".equals(field.getKey())) {
                    mediaType = field.getValue();
                    continue;
                }
                if ("mediaTypeNegate".equals(field.getKey())) {
                    mediaTypeNegate = field.getValue();
                    continue;
                }
                if ("group".equals(field.getKey())) {
                    group = field.getValue();
                    continue;
                }
                if ("group.ngroups".equals(field.getKey())) {
                    groupNGroups = field.getValue();
                    continue;
                }
                if ("group.format".equals(field.getKey())) {
                    groupFormat = field.getValue();
                    continue;
                }
                if ("group.field".equals(field.getKey())) {
                    groupField = field.getValue() + "_s";
                    continue;
                }
                if ("group.sort".equals(field.getKey())) {
                    String[] grpsort = field.getValue().split(" ");
                    if (grpsort.length > 1) {
                        groupSort = grpsort[0] + "_s" + " " + grpsort[1];
                        continue;
                    }
                    if (grpsort.length <= 0) continue;
                    groupSort = grpsort[0] + "_s" + " " + SolrQuery.ORDER.desc;
                    continue;
                }
                if ("author".equals(field.getKey())) {
                    createdBy = field.getValue();
                    continue;
                }
                if ("authorNameNegate".equals(field.getKey())) {
                    createdByNegate = field.getValue();
                    continue;
                }
                if ("updater".equals(field.getKey())) {
                    updatedBy = field.getValue();
                    continue;
                }
                if ("updaterNameNegate".equals(field.getKey())) {
                    updatedByNegate = field.getValue();
                    continue;
                }
                if ("createdRangeNegate".equals(field.getKey())) {
                    createdRangeNegate = field.getValue();
                    continue;
                }
                if ("updatedRangeNegate".equals(field.getKey())) {
                    updatedRangeNegate = field.getValue();
                    continue;
                }
                fieldKeySuffix = this.isMultiValueField(fields.get("mediaType"), field.getKey()) ? "_ss:" : "_s:";
                query.addFilterQuery(new String[]{field.getKey() + fieldKeySuffix + field.getValue()});
            }
            if (StringUtils.isNotEmpty((String)mediaType)) {
                fieldKey = "mediaType_s:";
                this.setQueryFilterSingleValue(query, fieldKey, mediaType, mediaTypeNegate);
            }
            if (StringUtils.isNotEmpty((String)createdBy)) {
                fieldKey = "author_s:";
                String createdByValue = this.getWildcardSearchQueryValue(createdBy);
                this.setQueryFilterSingleValue(query, fieldKey, createdByValue, createdByNegate);
            }
            if (StringUtils.isNotEmpty((String)group)) {
                this.addGroupingQuery(query, "group", group);
            }
            if (StringUtils.isNotEmpty((String)groupField)) {
                this.addGroupingQuery(query, "group.field", groupField);
            }
            if (StringUtils.isNotEmpty((String)groupSort)) {
                this.addGroupingQuery(query, "group.sort", groupSort);
            }
            if (StringUtils.isNotEmpty((String)groupNGroups)) {
                this.addGroupingQuery(query, "group.ngroups", groupNGroups);
            }
            if (StringUtils.isNotEmpty((String)groupFormat)) {
                this.addGroupingQuery(query, "group.format", groupFormat);
            }
            if (StringUtils.isNotEmpty((String)updatedBy)) {
                fieldKey = "updater_s:";
                String updatedByValue = this.getWildcardSearchQueryValue(updatedBy);
                this.setQueryFilterSingleValue(query, fieldKey, updatedByValue, updatedByNegate);
            }
            this.setQueryFilterDateRange(query, createdAfter, createdBefore, createdRangeNegate, "createdDate");
            this.setQueryFilterDateRange(query, updatedAfter, updatedBefore, updatedRangeNegate, "lastUpdatedDate");
            this.setQueryFilterProperty(query, propertyName, leftPropertyValue, leftOp, rightPropertyValue, rightOp);
            this.setQueryFilterResourceName(query, resourceName);
        }
    }

    private void setQueryFilterSingleValue(SolrQuery query, String fieldKey, String fieldValue, String fieldNegate) {
        String fieldQuery = StringUtils.isNotEmpty((String)fieldNegate) && fieldNegate.equalsIgnoreCase("on") ? fieldKey + "[* TO *] -" + fieldKey + fieldValue : fieldKey + fieldValue;
        query.addFilterQuery(new String[]{fieldQuery});
    }

    private void setQueryFilterResourceName(SolrQuery query, String resourceName) {
        if (StringUtils.isNotEmpty((String)resourceName)) {
            String fieldKeySuffix = "_s:";
            String resourceNameValue = this.getWildcardSearchQueryValue(resourceName);
            query.addFilterQuery(new String[]{"resourceName" + fieldKeySuffix + resourceNameValue});
        }
    }

    private void setQueryFilterProperty(SolrQuery query, String propertyName, String leftPropertyValue, String leftOp, String rightPropertyValue, String rightOp) {
        if (StringUtils.isNotEmpty((String)propertyName) && (leftPropertyValue != null && rightPropertyValue != null || rightOp.equals("eq"))) {
            int rightIntValue = 0;
            double rightDoubleValue = 0.0;
            if (StringUtils.isEmpty((String)leftPropertyValue) && StringUtils.isEmpty((String)rightPropertyValue)) {
                String fieldKeyInt = propertyName + "_is" + ":";
                String fieldKeyDouble = propertyName + "_ds" + ":";
                String fieldKeyString = propertyName + "_ss" + ":";
                query.addFilterQuery(new String[]{fieldKeyInt + "* | " + fieldKeyDouble + "* | " + fieldKeyString + "*"});
            }
            if (rightOp.equals("eq") && StringUtils.isNotEmpty((String)rightPropertyValue)) {
                this.setQueryFilterPropertyEqualOperation(query, propertyName, rightPropertyValue);
            } else {
                String rightValueType = this.getType(rightPropertyValue);
                String leftValueType = this.getType(leftPropertyValue);
                if (rightValueType.equals("int")) {
                    rightIntValue = Integer.parseInt(rightPropertyValue);
                    if (rightOp.equals("lt")) {
                        --rightIntValue;
                    }
                } else if (rightValueType.equals("double")) {
                    rightDoubleValue = Double.parseDouble(rightPropertyValue);
                    if (rightOp.equals("lt")) {
                        rightDoubleValue -= 0.1;
                    }
                }
                if (rightValueType.equals("int") || leftValueType.equals("int")) {
                    this.setQueryFilterForIntegerPropertyValues(query, propertyName, leftPropertyValue, rightPropertyValue, rightIntValue, leftOp, rightOp);
                } else if (rightValueType.equals("double") || leftValueType.equals("double")) {
                    this.setQueryFilterForDoublePropertyValues(query, propertyName, leftPropertyValue, rightPropertyValue, rightDoubleValue, leftOp, rightOp);
                }
            }
        }
    }

    private void setQueryFilterForDoublePropertyValues(SolrQuery query, String propertyName, String leftPropertyValue, String rightPropertyValue, double rightDoubleValue, String leftOp, String rightOp) {
        double leftDoubleValue = 0.0;
        if (StringUtils.isNotEmpty((String)leftPropertyValue)) {
            leftDoubleValue = Double.parseDouble(leftPropertyValue);
        }
        String fieldKey = propertyName + "_ds" + ":";
        if (leftOp.equals("gt") || leftOp.equals("ge") || leftOp.equals("na")) {
            if (leftOp.equals("gt")) {
                leftDoubleValue += 0.1;
            }
            if ((rightOp.equals("na") || StringUtils.isEmpty((String)rightPropertyValue)) && StringUtils.isNotEmpty((String)leftPropertyValue)) {
                query.addFilterQuery(new String[]{fieldKey + "[" + leftDoubleValue + " TO * ]"});
            } else if (StringUtils.isNotEmpty((String)rightPropertyValue) && StringUtils.isNotEmpty((String)leftPropertyValue)) {
                query.addFilterQuery(new String[]{fieldKey + "[" + leftDoubleValue + " TO " + rightDoubleValue + "]"});
            } else if ((leftOp.equals("na") || StringUtils.isEmpty((String)leftPropertyValue)) && StringUtils.isNotEmpty((String)rightPropertyValue)) {
                query.addFilterQuery(new String[]{fieldKey + "[ * TO " + rightDoubleValue + "]"});
            }
        }
    }

    private void setQueryFilterForIntegerPropertyValues(SolrQuery query, String propertyName, String leftPropertyValue, String rightPropertyValue, int rightIntValue, String leftOp, String rightOp) {
        int leftIntValue = 0;
        if (StringUtils.isNotEmpty((String)leftPropertyValue)) {
            leftIntValue = Integer.parseInt(leftPropertyValue);
        }
        String fieldKey = propertyName + "_is" + ":";
        if (leftOp.equals("gt") || leftOp.equals("ge") || leftOp.equals("na")) {
            if (leftOp.equals("gt")) {
                ++leftIntValue;
            }
            if ((rightOp.equals("na") || StringUtils.isEmpty((String)rightPropertyValue)) && StringUtils.isNotEmpty((String)leftPropertyValue)) {
                query.addFilterQuery(new String[]{fieldKey + "[" + leftIntValue + " TO * ]"});
            } else if (StringUtils.isNotEmpty((String)rightPropertyValue) && StringUtils.isNotEmpty((String)leftPropertyValue)) {
                query.addFilterQuery(new String[]{fieldKey + "[" + leftIntValue + " TO " + rightIntValue + "]"});
            } else if ((leftOp.equals("na") || StringUtils.isEmpty((String)leftPropertyValue)) && StringUtils.isNotEmpty((String)rightPropertyValue)) {
                query.addFilterQuery(new String[]{fieldKey + "[ * TO " + rightIntValue + "]"});
            }
        }
    }

    private void setQueryFilterPropertyEqualOperation(SolrQuery query, String propertyName, String rightPropertyValue) {
        String valueType = this.getType(rightPropertyValue);
        if (valueType.equals("int")) {
            int intValue = Integer.parseInt(rightPropertyValue);
            String fieldKey = propertyName + "_is" + ":";
            query.addFilterQuery(new String[]{fieldKey + intValue});
        } else if (valueType.equals("double")) {
            double doubleValue = Double.parseDouble(rightPropertyValue);
            String fieldKey = propertyName + "_ds" + ":";
            query.addFilterQuery(new String[]{fieldKey + doubleValue});
        } else if (valueType.equals("string")) {
            rightPropertyValue = this.getWildcardSearchQueryValue(rightPropertyValue);
            String fieldKey = propertyName + "_ss" + ":";
            query.addFilterQuery(new String[]{fieldKey + rightPropertyValue});
        }
    }

    private void setQueryFilterDateRange(SolrQuery query, String dateAfter, String dateBefore, String dateRangeNegate, String fieldKeyName) {
        String fieldKeySuffix = "_dt:[";
        if (StringUtils.isNotEmpty((String)dateAfter) && StringUtils.isNotEmpty((String)dateBefore)) {
            String dateRangeQuery = StringUtils.isNotEmpty((String)dateRangeNegate) && dateRangeNegate.equalsIgnoreCase("on") ? "(NOT " + fieldKeyName + fieldKeySuffix + this.toSolrDateFormat(dateAfter, "MM/dd/yyyy") + " TO " + this.toSolrDateFormat(dateBefore, "MM/dd/yyyy") + "])" : fieldKeyName + fieldKeySuffix + this.toSolrDateFormat(dateAfter, "MM/dd/yyyy") + " TO " + this.toSolrDateFormat(dateBefore, "MM/dd/yyyy") + "]";
            query.addFilterQuery(new String[]{dateRangeQuery});
        } else if (StringUtils.isNotEmpty((String)dateAfter)) {
            String dateRangeQuery = StringUtils.isNotEmpty((String)dateRangeNegate) && dateRangeNegate.equalsIgnoreCase("on") ? "(NOT " + fieldKeyName + fieldKeySuffix + this.toSolrDateFormat(dateAfter, "MM/dd/yyyy") + " TO NOW])" : fieldKeyName + fieldKeySuffix + this.toSolrDateFormat(dateAfter, "MM/dd/yyyy") + " TO NOW]";
            query.addFilterQuery(new String[]{dateRangeQuery});
        } else if (StringUtils.isNotEmpty((String)dateBefore)) {
            String dateRangeQuery = StringUtils.isNotEmpty((String)dateRangeNegate) && dateRangeNegate.equalsIgnoreCase("on") ? fieldKeyName + fieldKeySuffix + this.toSolrDateFormat(dateBefore, "MM/dd/yyyy") + " TO NOW]" : "(NOT " + fieldKeyName + fieldKeySuffix + this.toSolrDateFormat(dateBefore, "MM/dd/yyyy") + " TO NOW])";
            query.addFilterQuery(new String[]{dateRangeQuery});
        }
    }

    private String getWildcardSearchQueryValue(String fieldValue) {
        char lastCharacter = fieldValue.charAt(fieldValue.length() - 1);
        char firstCharacter = fieldValue.charAt(0);
        String result = lastCharacter == '%' && firstCharacter == '%' ? "*" + fieldValue.substring(1, fieldValue.length() - 1) + "*" : (lastCharacter == '%' ? fieldValue.substring(0, fieldValue.length() - 1) + "*" : (firstCharacter == '%' ? "*" + fieldValue.substring(1, fieldValue.length()) : fieldValue));
        return result;
    }

    @Deprecated
    public void cleanAllDocuments() {
        try {
            QueryResponse results = this.server.query((SolrParams)new SolrQuery("ICWS"));
            SolrDocumentList resultsList = results.getResults();
            for (SolrDocument aResultsList : resultsList) {
                String id = (String)aResultsList.getFieldValue("id");
                UpdateResponse deleteById = this.server.deleteById(id);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Deleted ID " + id + " Status " + deleteById.getStatus()));
            }
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private static String getLoggedInUserName() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
    }

    private String removeSpecialCharacters(String dateValue) {
        if (dateValue.startsWith("*")) {
            dateValue = dateValue.substring(1, dateValue.length());
        }
        if (dateValue.endsWith("*")) {
            dateValue = dateValue.substring(0, dateValue.length() - 1);
        }
        return dateValue;
    }

    private boolean isMultiValueField(String mediaType, String fieldKey) {
        List<String> fields;
        Map<String, List<String>> rxtDetails;
        boolean result = false;
        Map<Integer, Map<String, List<String>>> allTenantsUnboundedFields = RxtUnboundedFieldManagerService.getInstance().getTenantsUnboundedFields();
        if (allTenantsUnboundedFields.size() > 0 && (rxtDetails = allTenantsUnboundedFields.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId())) != null && (fields = rxtDetails.get(mediaType)) != null && fields.contains(fieldKey)) {
            result = true;
        }
        return result;
    }

    static {
        SOLR_HOME_FILE_PATH = CarbonUtils.getCarbonConfigDirPath() + File.separator + "solr";
    }
}

