/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class Mechanism {
    protected long pkcs11MechanismCode;
    protected Parameters parameters;

    public Mechanism(long pkcs11MechanismCode) {
        this.pkcs11MechanismCode = pkcs11MechanismCode;
    }

    public static Mechanism get(long pkcs11MechanismCode) {
        return new Mechanism(pkcs11MechanismCode);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Mechanism)) {
            return false;
        }
        Mechanism other = (Mechanism)otherObject;
        if (this.pkcs11MechanismCode != other.pkcs11MechanismCode) {
            return false;
        }
        return Util.objEquals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return (int)this.pkcs11MechanismCode;
    }

    public boolean isDigestMechanism() {
        return Functions.isDigestMechanism(this.pkcs11MechanismCode);
    }

    public boolean isFullEncryptDecryptMechanism() {
        return Functions.isFullEncryptDecryptMechanism(this.pkcs11MechanismCode);
    }

    public boolean isFullSignVerifyMechanism() {
        return Functions.isFullSignVerifyMechanism(this.pkcs11MechanismCode);
    }

    public boolean isKeyDerivationMechanism() {
        return Functions.isKeyDerivationMechanism(this.pkcs11MechanismCode);
    }

    public boolean isKeyGenerationMechanism() {
        return Functions.isKeyGenerationMechanism(this.pkcs11MechanismCode);
    }

    public boolean isKeyPairGenerationMechanism() {
        return Functions.isKeyPairGenerationMechanism(this.pkcs11MechanismCode);
    }

    public boolean isSignVerifyRecoverMechanism() {
        return Functions.isSignVerifyRecoverMechanism(this.pkcs11MechanismCode);
    }

    public boolean isSingleOperationEncryptDecryptMechanism() {
        return Functions.isSingleOperationEncryptDecryptMechanism(this.pkcs11MechanismCode);
    }

    public boolean isSingleOperationSignVerifyMechanism() {
        return Functions.isSingleOperationSignVerifyMechanism(this.pkcs11MechanismCode);
    }

    public boolean isWrapUnwrapMechanism() {
        return Functions.isWrapUnwrapMechanism(this.pkcs11MechanismCode);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public long getMechanismCode() {
        return this.pkcs11MechanismCode;
    }

    public String getName() {
        return Functions.mechanismCodeToString(this.pkcs11MechanismCode);
    }

    public String toString() {
        return Util.concatObjectsCap(128, "    Mechanism: ", Functions.mechanismCodeToString(this.pkcs11MechanismCode), "\n    Parameters:\n", this.parameters);
    }
}

