/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import sun.security.pkcs11.wrapper.CK_VERSION;

public class Version {
    protected byte major;
    protected byte minor;

    protected Version() {
    }

    protected Version(CK_VERSION ckVersion) {
        if (ckVersion == null) {
            throw new NullPointerException("Argument \"ckVersion\" must not be null.");
        }
        this.major = ckVersion.major;
        this.minor = ckVersion.minor;
    }

    public Object clone() {
        Version clone;
        try {
            clone = (Version)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", ex);
        }
        return clone;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.major & 0xFF);
        buffer.append('.');
        if (this.minor < 10) {
            buffer.append('0');
        }
        buffer.append(this.minor & 0xFF);
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof Version) {
            Version other = (Version)otherObject;
            equal = this == other || this.major == other.major && this.minor == other.minor;
        }
        return equal;
    }

    public int hashCode() {
        return this.major ^ this.minor;
    }
}

