/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CertificateTypeAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeatureTypeAttribute;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MechanismArrayAttribute;
import iaik.pkcs.pkcs11.objects.MechanismAttribute;
import iaik.pkcs.pkcs11.objects.ObjectClassAttribute;
import java.util.HashSet;
import java.util.Hashtable;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public abstract class Attribute {
    public static final long CLASS = 0L;
    public static final long TOKEN = 1L;
    public static final long PRIVATE = 2L;
    public static final long LABEL = 3L;
    public static final long APPLICATION = 16L;
    public static final long VALUE = 17L;
    public static final long OBJECT_ID = 18L;
    public static final long CERTIFICATE_TYPE = 128L;
    public static final long ISSUER = 129L;
    public static final long SERIAL_NUMBER = 130L;
    public static final long URL = 137L;
    public static final long HASH_OF_SUBJECT_PUBLIC_KEY = 138L;
    public static final long HASH_OF_ISSUER_PUBLIC_KEY = 139L;
    public static final long JAVA_MIDP_SECURITY_DOMAIN = 136L;
    public static final long AC_ISSUER = 131L;
    public static final long OWNER = 132L;
    public static final long ATTR_TYPES = 133L;
    public static final long TRUSTED = 134L;
    public static final long KEY_TYPE = 256L;
    public static final long SUBJECT = 257L;
    public static final long ID = 258L;
    public static final long CHECK_VALUE = 144L;
    public static final long CERTIFICATE_CATEGORY = 135L;
    public static final long SENSITIVE = 259L;
    public static final long ENCRYPT = 260L;
    public static final long DECRYPT = 261L;
    public static final long WRAP = 262L;
    public static final long WRAP_TEMPLATE = 1073742353L;
    public static final long UNWRAP = 263L;
    public static final long UNWRAP_TEMPLATE = 1073742354L;
    public static final long SIGN = 264L;
    public static final long SIGN_RECOVER = 265L;
    public static final long VERIFY = 266L;
    public static final long VERIFY_RECOVER = 267L;
    public static final long DERIVE = 268L;
    public static final long START_DATE = 272L;
    public static final long END_DATE = 273L;
    public static final long MECHANISM_TYPE = 1280L;
    public static final long MODULUS = 288L;
    public static final long MODULUS_BITS = 289L;
    public static final long PUBLIC_EXPONENT = 290L;
    public static final long PRIVATE_EXPONENT = 291L;
    public static final long PRIME_1 = 292L;
    public static final long PRIME_2 = 293L;
    public static final long EXPONENT_1 = 294L;
    public static final long EXPONENT_2 = 295L;
    public static final long COEFFICIENT = 296L;
    public static final long PRIME = 304L;
    public static final long SUBPRIME = 305L;
    public static final long BASE = 306L;
    public static final long PRIME_BITS = 307L;
    public static final long SUB_PRIME_BITS = 308L;
    public static final long VALUE_BITS = 352L;
    public static final long VALUE_LEN = 353L;
    public static final long EXTRACTABLE = 354L;
    public static final long LOCAL = 355L;
    public static final long NEVER_EXTRACTABLE = 356L;
    public static final long WRAP_WITH_TRUSTED = 528L;
    public static final long ALWAYS_SENSITIVE = 357L;
    public static final long ALWAYS_AUTHENTICATE = 514L;
    public static final long KEY_GEN_MECHANISM = 358L;
    public static final long ALLOWED_MECHANISMS = 0x40000600L;
    public static final long MODIFIABLE = 368L;
    public static final long EC_PARAMS = 384L;
    public static final long EC_POINT = 385L;
    public static final long SECONDARY_AUTH = 512L;
    public static final long AUTH_PIN_FLAGS = 513L;
    public static final long HW_FEATURE_TYPE = 768L;
    public static final long RESET_ON_INIT = 769L;
    public static final long HAS_RESET = 770L;
    public static final long VENDOR_DEFINED = 0x80000000L;
    public static final long PIXEL_X = 1024L;
    public static final long PIXEL_Y = 1025L;
    public static final long RESOLUTION = 1026L;
    public static final long CHAR_ROWS = 1027L;
    public static final long CHAR_COLUMNS = 1028L;
    public static final long COLOR = 1029L;
    public static final long BITS_PER_PIXEL = 1030L;
    public static final long CHAR_SETS = 1152L;
    public static final long ENCODING_METHODS = 1153L;
    public static final long MIME_TYPES = 1154L;
    protected static Hashtable<Long, String> attributeNames;
    protected static Hashtable<Long, Class<?>> attributeClasses;
    protected boolean present;
    protected boolean sensitive;
    protected CK_ATTRIBUTE ckAttribute;

    protected Attribute() {
    }

    protected Attribute(long type) {
        this.present = false;
        this.sensitive = false;
        this.ckAttribute = new CK_ATTRIBUTE();
        this.ckAttribute.type = type;
    }

    protected static synchronized String getAttributeName(long type) {
        String name;
        if (attributeNames == null) {
            attributeNames = new Hashtable(85);
            attributeNames.put(0L, "Class");
            attributeNames.put(1L, "Token");
            attributeNames.put(2L, "Private");
            attributeNames.put(3L, "Label");
            attributeNames.put(16L, "Application");
            attributeNames.put(17L, "Value");
            attributeNames.put(18L, "PKCS11Object ID");
            attributeNames.put(128L, "Certificate Type");
            attributeNames.put(129L, "Issuer");
            attributeNames.put(130L, "Serial Number");
            attributeNames.put(137L, "URL");
            attributeNames.put(138L, "Hash Of Subject Public Key");
            attributeNames.put(139L, "Hash Of Issuer Public Key");
            attributeNames.put(136L, "Java MIDP Security Domain");
            attributeNames.put(131L, "AC Issuer");
            attributeNames.put(132L, "Owner");
            attributeNames.put(133L, "Attribute Types");
            attributeNames.put(134L, "Trusted");
            attributeNames.put(256L, "Key Type");
            attributeNames.put(257L, "Subject");
            attributeNames.put(258L, "ID");
            attributeNames.put(144L, "Check Value");
            attributeNames.put(135L, "Certificate Category");
            attributeNames.put(259L, "Sensitive");
            attributeNames.put(260L, "Encrypt");
            attributeNames.put(261L, "Decrypt");
            attributeNames.put(262L, "Wrap");
            attributeNames.put(263L, "Unwrap");
            attributeNames.put(1073742353L, "Wrap Template");
            attributeNames.put(1073742354L, "Unwrap Template");
            attributeNames.put(264L, "Sign");
            attributeNames.put(265L, "Sign Recover");
            attributeNames.put(266L, "Verify");
            attributeNames.put(267L, "Verify Recover");
            attributeNames.put(268L, "Derive");
            attributeNames.put(272L, "Start Date");
            attributeNames.put(273L, "End Date");
            attributeNames.put(288L, "Modulus");
            attributeNames.put(289L, "Modulus Bits");
            attributeNames.put(290L, "Public Exponent");
            attributeNames.put(291L, "Private Exponent");
            attributeNames.put(292L, "Prime 1");
            attributeNames.put(293L, "Prime 2");
            attributeNames.put(294L, "Exponent 1");
            attributeNames.put(295L, "Exponent 2");
            attributeNames.put(296L, "Coefficient");
            attributeNames.put(304L, "Prime");
            attributeNames.put(305L, "Subprime");
            attributeNames.put(306L, "Base");
            attributeNames.put(307L, "Prime Pits");
            attributeNames.put(308L, "Subprime Bits");
            attributeNames.put(352L, "Value Bits");
            attributeNames.put(353L, "Value Length");
            attributeNames.put(354L, "Extractable");
            attributeNames.put(355L, "Local");
            attributeNames.put(356L, "Never Extractable");
            attributeNames.put(528L, "Wrap With Trusted");
            attributeNames.put(357L, "Always Sensitive");
            attributeNames.put(514L, "Always Authenticate");
            attributeNames.put(358L, "Key Generation Mechanism");
            attributeNames.put(0x40000600L, "Allowed Mechanisms");
            attributeNames.put(368L, "Modifiable");
            attributeNames.put(384L, "EC Parameters");
            attributeNames.put(385L, "EC Point");
            attributeNames.put(512L, "Secondary Authentication");
            attributeNames.put(513L, "Authentication PIN Flags");
            attributeNames.put(768L, "Hardware Feature Type");
            attributeNames.put(769L, "Reset on Initialization");
            attributeNames.put(770L, "Has been reset");
            attributeNames.put(0x80000000L, "Vendor Defined");
        }
        if ((type & 0x80000000L) != 0L) {
            StringBuilder nameBuffer = new StringBuilder(36);
            nameBuffer.append("VENDOR_DEFINED [0x");
            nameBuffer.append(Long.toHexString(type));
            nameBuffer.append(']');
            name = nameBuffer.toString();
        } else {
            name = attributeNames.get(type);
            if (name == null) {
                StringBuilder nameBuffer = new StringBuilder(25);
                nameBuffer.append("[0x");
                nameBuffer.append(Long.toHexString(type));
                nameBuffer.append(']');
                name = nameBuffer.toString();
            }
        }
        return name;
    }

    protected static synchronized Class<?> getAttributeClass(long type) {
        if (attributeClasses == null) {
            HashSet<Long> boolSet = new HashSet<Long>();
            HashSet<Long> longSet = new HashSet<Long>();
            HashSet<Long> barrSet = new HashSet<Long>();
            HashSet<Long> carrSet = new HashSet<Long>();
            attributeClasses = new Hashtable(85);
            attributeClasses.put(0L, ObjectClassAttribute.class);
            boolSet.add(1L);
            boolSet.add(2L);
            carrSet.add(3L);
            carrSet.add(16L);
            barrSet.add(17L);
            barrSet.add(18L);
            attributeClasses.put(128L, CertificateTypeAttribute.class);
            barrSet.add(129L);
            barrSet.add(130L);
            carrSet.add(137L);
            barrSet.add(138L);
            barrSet.add(139L);
            longSet.add(136L);
            barrSet.add(131L);
            barrSet.add(132L);
            barrSet.add(133L);
            boolSet.add(134L);
            attributeClasses.put(256L, KeyTypeAttribute.class);
            barrSet.add(257L);
            barrSet.add(258L);
            barrSet.add(144L);
            longSet.add(135L);
            boolSet.add(259L);
            boolSet.add(260L);
            boolSet.add(261L);
            boolSet.add(262L);
            boolSet.add(263L);
            attributeClasses.put(1073742353L, AttributeArray.class);
            attributeClasses.put(1073742354L, AttributeArray.class);
            boolSet.add(264L);
            boolSet.add(265L);
            boolSet.add(266L);
            boolSet.add(267L);
            boolSet.add(268L);
            attributeClasses.put(272L, DateAttribute.class);
            attributeClasses.put(273L, DateAttribute.class);
            barrSet.add(288L);
            attributeClasses.put(289L, LongAttribute.class);
            barrSet.add(290L);
            barrSet.add(291L);
            barrSet.add(292L);
            barrSet.add(293L);
            barrSet.add(294L);
            barrSet.add(295L);
            barrSet.add(296L);
            barrSet.add(304L);
            barrSet.add(305L);
            barrSet.add(306L);
            longSet.add(307L);
            longSet.add(308L);
            longSet.add(352L);
            longSet.add(353L);
            boolSet.add(354L);
            boolSet.add(355L);
            boolSet.add(356L);
            boolSet.add(528L);
            boolSet.add(357L);
            boolSet.add(514L);
            attributeClasses.put(358L, MechanismAttribute.class);
            attributeClasses.put(0x40000600L, MechanismArrayAttribute.class);
            boolSet.add(368L);
            barrSet.add(384L);
            barrSet.add(385L);
            boolSet.add(512L);
            longSet.add(513L);
            attributeClasses.put(768L, HardwareFeatureTypeAttribute.class);
            boolSet.add(769L);
            boolSet.add(770L);
            for (Long m : boolSet) {
                attributeClasses.put(m, BooleanAttribute.class);
            }
            for (Long m : longSet) {
                attributeClasses.put(m, LongAttribute.class);
            }
            for (Long m : barrSet) {
                attributeClasses.put(m, ByteArrayAttribute.class);
            }
            for (Long m : carrSet) {
                attributeClasses.put(m, CharArrayAttribute.class);
            }
        }
        return attributeClasses.get(type);
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public abstract void setValue(Object var1);

    protected void setCkAttribute(CK_ATTRIBUTE ckAttribute) {
        this.ckAttribute = Util.requireNonNull("ckAttribute", ckAttribute);
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    protected CK_ATTRIBUTE getCkAttribute() {
        return this.ckAttribute;
    }

    protected String getValueString() {
        if (this.ckAttribute != null && this.ckAttribute.pValue != null) {
            return this.ckAttribute.pValue.toString();
        }
        return "<NULL_PTR>";
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withName) {
        StringBuilder sb = new StringBuilder(32);
        if (withName) {
            String typeName = Attribute.getAttributeName(this.ckAttribute.type);
            sb.append(typeName).append(": ");
        }
        if (this.present) {
            if (this.sensitive) {
                sb.append("<Value is sensitive>");
            } else {
                sb.append(this.getValueString());
            }
        } else {
            sb.append("<Attribute not present>");
        }
        return sb.toString();
    }

    protected void setType(long type) {
        this.ckAttribute.type = type;
    }

    protected Long getType() {
        return this.ckAttribute.type;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)otherObject;
        if (!this.present && !other.present) {
            return true;
        }
        if (!this.present || !other.present) {
            return false;
        }
        if (this.sensitive != other.sensitive) {
            return false;
        }
        if (this.ckAttribute.type != other.ckAttribute.type) {
            return false;
        }
        return Util.objEquals(this.ckAttribute.pValue, other.ckAttribute.pValue);
    }

    public int hashCode() {
        int valueHashCode = this.ckAttribute.pValue != null ? this.ckAttribute.pValue.hashCode() : 0;
        return (int)this.ckAttribute.type ^ valueHashCode;
    }
}

