/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.OtherAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import java.util.ArrayList;
import java.util.Enumeration;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public class AttributeArray
extends Attribute {
    protected PKCS11Object template;

    public AttributeArray(Long type) {
        super(type);
    }

    public void setAttributeArrayValue(PKCS11Object value) {
        this.template = value;
        ArrayList<CK_ATTRIBUTE> attributeList = new ArrayList<CK_ATTRIBUTE>();
        Enumeration<Attribute> attributeEnumeration = this.template.attributeTable.elements();
        while (attributeEnumeration.hasMoreElements()) {
            Attribute attribute = attributeEnumeration.nextElement();
            if (!attribute.present) continue;
            attributeList.add(attribute.getCkAttribute());
        }
        this.ckAttribute.pValue = attributeList.toArray(new CK_ATTRIBUTE[0]);
        this.present = true;
    }

    public PKCS11Object getAttributeArrayValue() {
        if (this.template != null) {
            return this.template;
        }
        if (this.ckAttribute.pValue == null || ((CK_ATTRIBUTE[])this.ckAttribute.pValue).length <= 0) {
            return null;
        }
        CK_ATTRIBUTE[] attributesArray = (CK_ATTRIBUTE[])this.ckAttribute.pValue;
        GenericTemplate template = new GenericTemplate();
        for (CK_ATTRIBUTE ck_attribute : attributesArray) {
            Attribute attribute;
            Long type = ck_attribute.type;
            Class<?> implementation = Attribute.getAttributeClass(type);
            if (implementation == null) {
                attribute = new OtherAttribute();
                attribute.setType(type);
                attribute.setCkAttribute(ck_attribute);
                continue;
            }
            try {
                attribute = (Attribute)implementation.getDeclaredConstructor(Attribute.class).newInstance(new Object[0]);
                attribute.setCkAttribute(ck_attribute);
                attribute.setPresent(true);
                template.addAttribute(attribute);
            }
            catch (Exception ex) {
                System.err.println("Error when trying to create a " + implementation + " instance for " + type + ": " + ex.getMessage());
            }
        }
        return template;
    }

    @Override
    protected String getValueString() {
        if (this.template == null) {
            this.template = this.getAttributeArrayValue();
        }
        return this.template == null ? "<NULL_PTR>" : this.template.toString(true, true, "      ");
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof AttributeArray)) {
            return false;
        }
        AttributeArray other = (AttributeArray)otherObject;
        if (this.template == null) {
            this.template = this.getAttributeArrayValue();
        }
        if (other.template == null) {
            other.template = other.getAttributeArrayValue();
        }
        if (!this.present && !other.present) {
            return true;
        }
        if (!this.present || !other.present) {
            return false;
        }
        if (this.sensitive != other.sensitive) {
            return false;
        }
        return this.template.equals(other.template);
    }

    @Override
    public int hashCode() {
        if (this.template == null) {
            this.template = this.getAttributeArrayValue();
        }
        return this.template.hashCode();
    }

    @Override
    public void setValue(Object value) throws UnsupportedOperationException {
        this.setAttributeArrayValue((PKCS11Object)value);
    }
}

