/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;

public class ECPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute ecdsaParams;
    protected ByteArrayAttribute value;

    public ECPrivateKey() {
        this(3L);
    }

    public ECPrivateKey(long keyType) {
        this.keyType.setLongValue(keyType);
    }

    public static ECPrivateKey newSM2PrivateKey(Module module) {
        long keyType = 0xFFFFF001L;
        if (module.getVendorCodeConverter() != null) {
            keyType = module.getVendorCodeConverter().genericToVendorCKK(keyType);
        }
        return new ECPrivateKey(keyType);
    }

    protected ECPrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new ECPrivateKey(session, objectHandle);
    }

    protected static void putAttributesInTable(ECPrivateKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(256L, object.keyType);
        object.attributeTable.put(384L, object.ecdsaParams);
        object.attributeTable.put(17L, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.ecdsaParams = new ByteArrayAttribute((Long)384L);
        this.value = new ByteArrayAttribute((Long)17L);
        ECPrivateKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof ECPrivateKey)) {
            return false;
        }
        ECPrivateKey other = (ECPrivateKey)otherObject;
        return super.equals(other) && this.ecdsaParams.equals(other.ecdsaParams) && this.value.equals(other.value);
    }

    public ByteArrayAttribute getEcdsaParams() {
        return this.ecdsaParams;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.ecdsaParams, this.value});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  ECDSA Params (DER, hex): ", this.ecdsaParams, "\n  Private Value d (hex): ", this.value);
    }
}

