/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;

public class RSAPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute modulus;
    protected ByteArrayAttribute publicExponent;
    protected ByteArrayAttribute privateExponent;
    protected ByteArrayAttribute prime1;
    protected ByteArrayAttribute prime2;
    protected ByteArrayAttribute exponent1;
    protected ByteArrayAttribute exponent2;
    protected ByteArrayAttribute coefficient;

    public RSAPrivateKey() {
        this.keyType.setLongValue(0L);
    }

    protected RSAPrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(0L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new RSAPrivateKey(session, objectHandle);
    }

    protected static void putAttributesInTable(RSAPrivateKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(288L, object.modulus);
        object.attributeTable.put(290L, object.publicExponent);
        object.attributeTable.put(291L, object.privateExponent);
        object.attributeTable.put(292L, object.prime1);
        object.attributeTable.put(293L, object.prime2);
        object.attributeTable.put(294L, object.exponent1);
        object.attributeTable.put(295L, object.exponent2);
        object.attributeTable.put(296L, object.coefficient);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.modulus = new ByteArrayAttribute((Long)288L);
        this.publicExponent = new ByteArrayAttribute((Long)290L);
        this.privateExponent = new ByteArrayAttribute((Long)291L);
        this.prime1 = new ByteArrayAttribute((Long)292L);
        this.prime2 = new ByteArrayAttribute((Long)293L);
        this.exponent1 = new ByteArrayAttribute((Long)294L);
        this.exponent2 = new ByteArrayAttribute((Long)295L);
        this.coefficient = new ByteArrayAttribute((Long)296L);
        RSAPrivateKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPrivateKey)) {
            return false;
        }
        RSAPrivateKey other = (RSAPrivateKey)otherObject;
        return super.equals(other) && this.modulus.equals(other.modulus) && this.publicExponent.equals(other.publicExponent) && this.privateExponent.equals(other.privateExponent) && this.prime1.equals(other.prime1) && this.prime2.equals(other.prime2) && this.exponent1.equals(other.exponent1) && this.exponent2.equals(other.exponent2) && this.coefficient.equals(other.coefficient);
    }

    public ByteArrayAttribute getModulus() {
        return this.modulus;
    }

    public ByteArrayAttribute getPublicExponent() {
        return this.publicExponent;
    }

    public ByteArrayAttribute getPrivateExponent() {
        return this.privateExponent;
    }

    public ByteArrayAttribute getPrime1() {
        return this.prime1;
    }

    public ByteArrayAttribute getPrime2() {
        return this.prime2;
    }

    public ByteArrayAttribute getExponent1() {
        return this.exponent1;
    }

    public ByteArrayAttribute getExponent2() {
        return this.exponent2;
    }

    public ByteArrayAttribute getCoefficient() {
        return this.coefficient;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.modulus, this.publicExponent, this.privateExponent, this.prime1, this.prime2, this.exponent1, this.exponent2, this.coefficient});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Modulus (hex): ", this.modulus, "\n  Public Exponent (hex): ", this.publicExponent, "\n  Private Exponent (hex): ", this.privateExponent, "\n  Prime 1 (hex): ", this.prime1, "\n  Prime 2 (hex): ", this.prime2, "\n  Exponent 1 (hex): ", this.exponent1, "\n  Exponent 2 (hex): ", this.exponent2, "\n  Coefficient (hex): ", this.coefficient);
    }
}

