/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PublicKey;

public class RSAPublicKey
extends PublicKey {
    protected ByteArrayAttribute modulus;
    protected ByteArrayAttribute publicExponent;
    protected LongAttribute modulusBits;

    public RSAPublicKey() {
        this.keyType.setLongValue(0L);
    }

    protected RSAPublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(0L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new RSAPublicKey(session, objectHandle);
    }

    protected static void putAttributesInTable(RSAPublicKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(288L, object.modulus);
        object.attributeTable.put(290L, object.publicExponent);
        object.attributeTable.put(289L, object.modulusBits);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.modulus = new ByteArrayAttribute((Long)288L);
        this.publicExponent = new ByteArrayAttribute((Long)290L);
        this.modulusBits = new LongAttribute((Long)289L);
        RSAPublicKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey other = (RSAPublicKey)otherObject;
        return super.equals(other) && this.modulus.equals(other.modulus) && this.publicExponent.equals(other.publicExponent) && this.modulusBits.equals(other.modulusBits);
    }

    public ByteArrayAttribute getModulus() {
        return this.modulus;
    }

    public ByteArrayAttribute getPublicExponent() {
        return this.publicExponent;
    }

    public LongAttribute getModulusBits() {
        return this.modulusBits;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.modulus, this.publicExponent, this.modulusBits});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Modulus (hex): ", this.modulus, "\n  Public Exponent (hex): ", this.publicExponent, "\n  Modulus Bits (dec): ", this.modulusBits.toString(10));
    }
}

