/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import java.nio.charset.StandardCharsets;

public class UserInterface
extends HardwareFeature {
    private LongAttribute pixelX;
    private LongAttribute pixelY;
    private LongAttribute resolution;
    private LongAttribute charRows;
    private LongAttribute charColumns;
    private BooleanAttribute color;
    private LongAttribute bitsPerPixel;
    private ByteArrayAttribute charSets;
    private ByteArrayAttribute encodingMethods;
    private ByteArrayAttribute mimeTypes;

    public UserInterface() {
        this.hardwareFeatureType.setLongValue(3L);
    }

    protected UserInterface(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.hardwareFeatureType.setLongValue(3L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new UserInterface(session, objectHandle);
    }

    protected static void putAttributesInTable(UserInterface object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(1024L, object.pixelX);
        object.attributeTable.put(1025L, object.pixelY);
        object.attributeTable.put(1026L, object.resolution);
        object.attributeTable.put(1027L, object.charRows);
        object.attributeTable.put(1028L, object.charColumns);
        object.attributeTable.put(1029L, object.color);
        object.attributeTable.put(1030L, object.bitsPerPixel);
        object.attributeTable.put(1152L, object.charSets);
        object.attributeTable.put(1153L, object.encodingMethods);
        object.attributeTable.put(1154L, object.mimeTypes);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.pixelX = new LongAttribute((Long)1024L);
        this.pixelY = new LongAttribute((Long)1025L);
        this.resolution = new LongAttribute((Long)1026L);
        this.charRows = new LongAttribute((Long)1027L);
        this.charColumns = new LongAttribute((Long)1028L);
        this.color = new BooleanAttribute((Long)1029L);
        this.bitsPerPixel = new LongAttribute((Long)1030L);
        this.charSets = new ByteArrayAttribute((Long)1152L);
        this.encodingMethods = new ByteArrayAttribute((Long)1153L);
        this.mimeTypes = new ByteArrayAttribute((Long)1154L);
        UserInterface.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!super.equals(otherObject)) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        UserInterface other = (UserInterface)otherObject;
        return Util.objEquals(this.bitsPerPixel, other.bitsPerPixel) && Util.objEquals(this.charColumns, other.charColumns) && Util.objEquals(this.charRows, other.charRows) && Util.objEquals(this.charSets, other.charSets) && Util.objEquals(this.color, other.color) && Util.objEquals(this.encodingMethods, other.encodingMethods) && Util.objEquals(this.mimeTypes, other.mimeTypes) && Util.objEquals(this.pixelX, other.pixelX) && Util.objEquals(this.pixelY, other.pixelY) && Util.objEquals(this.resolution, other.resolution);
    }

    public LongAttribute getPixelX() {
        return this.pixelX;
    }

    public LongAttribute getPixelY() {
        return this.pixelY;
    }

    public LongAttribute getResolution() {
        return this.resolution;
    }

    public LongAttribute getCharRows() {
        return this.charRows;
    }

    public LongAttribute getCharColumns() {
        return this.charColumns;
    }

    public BooleanAttribute getColor() {
        return this.color;
    }

    public LongAttribute getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public ByteArrayAttribute getCharSets() {
        return this.charSets;
    }

    public ByteArrayAttribute getEncodingMethods() {
        return this.encodingMethods;
    }

    public ByteArrayAttribute getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public int hashCode() {
        return this.pixelX.hashCode() ^ this.pixelY.hashCode() ^ this.resolution.hashCode() ^ this.charRows.hashCode() ^ this.charColumns.hashCode() ^ this.color.hashCode() ^ this.bitsPerPixel.hashCode() ^ this.charSets.hashCode() ^ this.encodingMethods.hashCode() ^ this.mimeTypes.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.pixelX, this.pixelY, this.resolution, this.charRows, this.charColumns, this.color, this.bitsPerPixel, this.charSets, this.encodingMethods, this.mimeTypes});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Pixel X: ", this.pixelX.getValueString(), "\n  Pixel Y: ", this.pixelY.getValueString(), "\n  Resolution: ", this.resolution.getValueString(), "\n  Char Rows: ", this.charRows.getValueString(), "\n  Char Columns: ", this.charColumns.getValueString(), "\n  Color: ", this.color.getValueString(), "\n  Bits per Pixel: ", this.bitsPerPixel.getValueString(), "\n  Char sets:", UserInterface.toString(this.charSets), "\n  Encoding methods: ", UserInterface.toString(this.encodingMethods), "\n  Mime Types: ", UserInterface.toString(this.mimeTypes));
    }

    private static String toString(ByteArrayAttribute attr) {
        return new String(attr.getByteArrayValue(), StandardCharsets.US_ASCII);
    }
}

