/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class X509PublicKeyCertificate
extends Certificate {
    protected ByteArrayAttribute subject;
    protected ByteArrayAttribute id;
    protected ByteArrayAttribute issuer;
    protected ByteArrayAttribute serialNumber;
    protected ByteArrayAttribute value;
    protected CharArrayAttribute url;
    protected ByteArrayAttribute hashOfSubjectPublicKey;
    protected ByteArrayAttribute hashOfIssuerPublicKey;
    protected LongAttribute javaMidpSecurityDomain;

    public X509PublicKeyCertificate() {
        this.certificateType.setLongValue(0L);
    }

    protected X509PublicKeyCertificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.certificateType.setLongValue(0L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X509PublicKeyCertificate(session, objectHandle);
    }

    protected static void putAttributesInTable(X509PublicKeyCertificate object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(257L, object.subject);
        object.attributeTable.put(258L, object.id);
        object.attributeTable.put(129L, object.issuer);
        object.attributeTable.put(130L, object.serialNumber);
        object.attributeTable.put(17L, object.value);
        object.attributeTable.put(137L, object.url);
        object.attributeTable.put(138L, object.hashOfSubjectPublicKey);
        object.attributeTable.put(139L, object.hashOfIssuerPublicKey);
        object.attributeTable.put(136L, object.javaMidpSecurityDomain);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute((Long)257L);
        this.id = new ByteArrayAttribute((Long)258L);
        this.issuer = new ByteArrayAttribute((Long)129L);
        this.serialNumber = new ByteArrayAttribute((Long)130L);
        this.value = new ByteArrayAttribute((Long)17L);
        this.url = new CharArrayAttribute(137L);
        this.hashOfSubjectPublicKey = new ByteArrayAttribute((Long)138L);
        this.hashOfIssuerPublicKey = new ByteArrayAttribute((Long)139L);
        this.javaMidpSecurityDomain = new LongAttribute((Long)136L);
        X509PublicKeyCertificate.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X509PublicKeyCertificate)) {
            return false;
        }
        X509PublicKeyCertificate other = (X509PublicKeyCertificate)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.id.equals(other.id) && this.issuer.equals(other.issuer) && this.serialNumber.equals(other.serialNumber) && this.value.equals(other.value) && this.url.equals(other.url) && this.hashOfSubjectPublicKey.equals(other.hashOfSubjectPublicKey) && this.hashOfIssuerPublicKey.equals(other.hashOfIssuerPublicKey) && this.javaMidpSecurityDomain.equals(other.javaMidpSecurityDomain);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public ByteArrayAttribute getId() {
        return this.id;
    }

    public ByteArrayAttribute getIssuer() {
        return this.issuer;
    }

    public ByteArrayAttribute getSerialNumber() {
        return this.serialNumber;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    public CharArrayAttribute getUrl() {
        return this.url;
    }

    public ByteArrayAttribute getHashOfSubjectPublicKey() {
        return this.hashOfSubjectPublicKey;
    }

    public ByteArrayAttribute getHashOfIssuerPublicKey() {
        return this.hashOfIssuerPublicKey;
    }

    public LongAttribute getJavaMidpSecurityDomain() {
        return this.javaMidpSecurityDomain;
    }

    @Override
    public int hashCode() {
        return this.issuer.hashCode() ^ this.serialNumber.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.id, this.issuer, this.serialNumber, this.value, this.url, this.hashOfSubjectPublicKey, this.hashOfIssuerPublicKey, this.javaMidpSecurityDomain});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 200, superToString, "\n  Subject (DER, hex): ", this.subject, "\n  ID (hex): ", this.id, "\n  Issuer (DER, hex): ", this.issuer, "\n  Serial Number (DER, hex): ", this.serialNumber, "\n  Value (BER, hex): ", this.value, "\n  URL: ", this.url, "\n  Hash Of Subject Public Key: ", this.hashOfSubjectPublicKey, "\n  Hash Of Issuer Public Key: ", this.hashOfIssuerPublicKey, "\n  Java MIDP Security Domain: ", this.javaMidpSecurityDomain);
    }
}

