/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHParams;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class X942DHParams
extends DHParams {
    protected ByteArrayAttribute subprime;
    protected LongAttribute subprimeBits;

    public X942DHParams() {
        this.keyType.setLongValue(4L);
    }

    protected X942DHParams(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(4L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X942DHParams(session, objectHandle);
    }

    protected static void putAttributesInTable(X942DHParams object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(304L, object.prime);
        object.attributeTable.put(306L, object.base);
        object.attributeTable.put(305L, object.subprime);
        object.attributeTable.put(307L, object.primeBits);
        object.attributeTable.put(308L, object.subprimeBits);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute((Long)304L);
        this.base = new ByteArrayAttribute((Long)306L);
        this.subprime = new ByteArrayAttribute((Long)305L);
        this.primeBits = new LongAttribute((Long)307L);
        this.subprimeBits = new LongAttribute((Long)308L);
        X942DHParams.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X942DHParams)) {
            return false;
        }
        X942DHParams other = (X942DHParams)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.base.equals(other.base) && this.subprime.equals(other.subprime) && this.primeBits.equals(other.primeBits) && this.subprimeBits.equals(other.subprimeBits);
    }

    @Override
    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    @Override
    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime;
    }

    @Override
    public LongAttribute getPrimeBits() {
        return this.primeBits;
    }

    public LongAttribute getSubprimeBits() {
        return this.subprimeBits;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.base, this.subprime, this.primeBits, this.subprimeBits});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Base (hex): ", this.base, "\n  Subprime (hex): ", this.subprime, "\n  Prime Bits (dec): ", this.primeBits.toString(10), "\n  Subprime Bits (dec): ", this.subprimeBits.toString(10));
    }
}

