/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.DHKeyDerivationParameters;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;

public class EcDH1KeyDerivationParameters
extends DHKeyDerivationParameters {
    protected byte[] sharedData;

    public EcDH1KeyDerivationParameters(long kdf, byte[] sharedData, byte[] publicData) {
        super(kdf, publicData);
        this.sharedData = sharedData;
    }

    @Override
    public CK_ECDH1_DERIVE_PARAMS getPKCS11ParamsObject() {
        return new CK_ECDH1_DERIVE_PARAMS(this.kdf, this.sharedData, this.publicData);
    }

    public byte[] getSharedData() {
        return this.sharedData;
    }

    public void setSharedData(byte[] sharedData) {
        this.sharedData = sharedData;
    }

    @Override
    public String toString() {
        return Util.concat(super.toString(), "\n  Shared Data: ", Util.toHex(this.sharedData));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof EcDH1KeyDerivationParameters)) {
            return false;
        }
        EcDH1KeyDerivationParameters other = (EcDH1KeyDerivationParameters)otherObject;
        return super.equals(other) && Arrays.equals(this.sharedData, other.sharedData);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Util.hashCode(this.sharedData);
    }
}

