/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class GCMParameters
implements Parameters {
    public static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_GCM_PARAMS";
    private static final Constructor<?> constructor = Util.getConstructor("sun.security.pkcs11.wrapper.CK_GCM_PARAMS", Integer.TYPE, byte[].class, byte[].class);
    private final byte[] iv;
    private final byte[] aad;
    private final int tagLen;

    public GCMParameters(int tagLen, byte[] iv, byte[] aad) {
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_GCM_PARAMS is not available in the JDK");
        }
        this.iv = iv;
        this.aad = aad;
        this.tagLen = tagLen;
    }

    public String toString() {
        return Util.concatObjectsCap(100, "\n  iv: ", Functions.toHexString(this.iv), "\n  aad: ", Functions.toHexString(this.aad), "\n  tagLen: ", this.tagLen);
    }

    public int hashCode() {
        return Util.hashCode(this.iv) ^ Util.hashCode(this.aad) ^ this.tagLen;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        try {
            return constructor.newInstance(this.tagLen << 3, this.iv, this.aad);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_GCM_PARAMS", ex);
        }
    }
}

