/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.RSAPkcsParameters;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_OAEP_PARAMS;

public class RSAPkcsOaepParameters
extends RSAPkcsParameters {
    protected long source;
    protected byte[] sourceData;

    @Deprecated
    public RSAPkcsOaepParameters(Mechanism hashAlgorithm, long maskGenerationFunction, long source, byte[] sourceData) {
        this(hashAlgorithm.getMechanismCode(), maskGenerationFunction, source, sourceData);
    }

    public RSAPkcsOaepParameters(long hashAlgorithm, long maskGenerationFunction, long source, byte[] sourceData) {
        super(hashAlgorithm, maskGenerationFunction);
        if (source != 0L && source != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"source\": " + Long.toHexString(source));
        }
        this.source = source;
        this.sourceData = sourceData;
    }

    @Override
    public CK_RSA_PKCS_OAEP_PARAMS getPKCS11ParamsObject() {
        CK_RSA_PKCS_OAEP_PARAMS params = new CK_RSA_PKCS_OAEP_PARAMS();
        params.hashAlg = this.hashAlg;
        params.mgf = this.mgf;
        params.source = this.source;
        params.pSourceData = this.sourceData;
        return params;
    }

    public long getSource() {
        return this.source;
    }

    public byte[] getSourceData() {
        return this.sourceData;
    }

    public void setSource(long source) {
        if (source != 0L && source != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"source\": " + Long.toHexString(source));
        }
        this.source = source;
    }

    public void setSourceData(byte[] sourceData) {
        this.sourceData = sourceData;
    }

    @Override
    public String toString() {
        String sourceStr = this.source == 0L ? "Empty" : (this.source == 1L ? "Data Specified" : "<unknown>");
        String upperStr = super.toString();
        return Util.concatObjectsCap(upperStr.length() + 100, upperStr, "\n  Source: ", sourceStr, "\n  Source Data (hex): ", Util.toHex(this.sourceData));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPkcsOaepParameters)) {
            return false;
        }
        RSAPkcsOaepParameters other = (RSAPkcsOaepParameters)otherObject;
        return super.equals(other) && this.source == other.source && Arrays.equals(this.sourceData, other.sourceData);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.source ^ Util.hashCode(this.sourceData);
    }

    public static interface SourceType {
        public static final long EMPTY = 0L;
        public static final long SALT_SPECIFIED = 1L;
        @Deprecated
        public static final long DATA_SPECIFIED = 1L;
    }
}

