/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;

public class SSL3KeyMaterialOutParameters
implements Parameters {
    protected SecretKey clientMacSecret;
    protected SecretKey serverMacSecret;
    protected SecretKey clientKey;
    protected SecretKey serverKey;
    protected byte[] clientIV;
    protected byte[] serverIV;

    public SSL3KeyMaterialOutParameters(byte[] clientIV, byte[] serverIV) {
        this.clientIV = Util.requireNonNull("clientIV", clientIV);
        this.serverIV = Util.requireNonNull("serverIV", serverIV);
    }

    @Override
    public CK_SSL3_KEY_MAT_OUT getPKCS11ParamsObject() {
        CK_SSL3_KEY_MAT_OUT params = new CK_SSL3_KEY_MAT_OUT();
        params.hClientMacSecret = this.clientMacSecret != null ? this.clientMacSecret.getObjectHandle() : 0L;
        params.hServerMacSecret = this.serverMacSecret != null ? this.serverMacSecret.getObjectHandle() : 0L;
        params.hClientKey = this.clientKey != null ? this.clientKey.getObjectHandle() : 0L;
        params.hServerKey = this.serverKey != null ? this.serverKey.getObjectHandle() : 0L;
        params.pIVClient = this.clientIV;
        params.pIVServer = this.serverIV;
        return params;
    }

    public void setPKCS11ParamsObject(CK_SSL3_KEY_MAT_OUT input, Session session) throws TokenException {
        this.clientMacSecret = (SecretKey)PKCS11Object.getInstance(session, input.hClientMacSecret);
        this.serverMacSecret = (SecretKey)PKCS11Object.getInstance(session, input.hServerMacSecret);
        this.clientKey = (SecretKey)PKCS11Object.getInstance(session, input.hClientKey);
        this.serverKey = (SecretKey)PKCS11Object.getInstance(session, input.hServerKey);
        this.clientIV = input.pIVClient;
        this.serverIV = input.pIVServer;
    }

    public SecretKey getClientMacSecret() {
        return this.clientMacSecret;
    }

    public SecretKey getServerMacSecret() {
        return this.serverMacSecret;
    }

    public SecretKey getClientSecret() {
        return this.clientKey;
    }

    public SecretKey getServerSecret() {
        return this.serverKey;
    }

    public byte[] getClientIV() {
        return this.clientIV;
    }

    public byte[] getServerIV() {
        return this.serverIV;
    }

    public String toString() {
        return Util.concatObjects("  Client MAC Secret key:\n", this.clientMacSecret, "\n\n  Server MAC Secret key:\n", this.serverMacSecret, "\n\n  Client Secret key:\n", this.clientKey, "\n\n  Server Secret key:\n", this.serverKey, "\n\n  Client Initializatin Vector (hex):\n", Util.toHex(this.clientIV), "\n  Server Initializatin Vector (hex): ", Util.toHex(this.serverIV));
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SSL3KeyMaterialOutParameters)) {
            return false;
        }
        SSL3KeyMaterialOutParameters other = (SSL3KeyMaterialOutParameters)otherObject;
        return Util.objEquals(this.clientMacSecret, other.clientMacSecret) && Util.objEquals(this.serverMacSecret, other.serverMacSecret) && Util.objEquals(this.clientKey, other.clientKey) && Util.objEquals(this.serverKey, other.serverKey) && Arrays.equals(this.clientIV, other.clientIV) && Arrays.equals(this.serverIV, other.serverIV);
    }

    public int hashCode() {
        return (this.clientMacSecret != null ? this.clientMacSecret.hashCode() : 0) ^ (this.serverMacSecret != null ? this.serverMacSecret.hashCode() : 0) ^ (this.clientKey != null ? this.clientKey.hashCode() : 0) ^ (this.serverKey != null ? this.serverKey.hashCode() : 0);
    }
}

