/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialOutParameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;
import iaik.pkcs.pkcs11.parameters.TLSKeyMaterialParameters;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;

public class TLS12KeyMaterialParameters
extends TLSKeyMaterialParameters {
    public static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS";
    private static final Constructor<?> constructor;
    private static final Field field_pReturnedKeyMaterial;
    public long prfHashMechanism;

    public static CK_SSL3_KEY_MAT_OUT getPReturnedKeyMaterial(Object object) {
        if (field_pReturnedKeyMaterial == null) {
            throw new IllegalStateException("field field_pReturnedKeyMaterial does not exist");
        }
        try {
            return (CK_SSL3_KEY_MAT_OUT)field_pReturnedKeyMaterial.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalStateException("could not get field_pReturnedKeyMaterial", ex);
        }
    }

    public TLS12KeyMaterialParameters(int macSize, int keySize, int ivSize, boolean export, SSL3RandomDataParameters random, SSL3KeyMaterialOutParameters returnedKeyMaterial, long prfHashMechanism) {
        super(macSize, keySize, ivSize, export, random, returnedKeyMaterial);
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS is not available in the JDK");
        }
        if (field_pReturnedKeyMaterial == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS.pReturnedKeyMaterialField is not available in the JDK");
        }
        this.prfHashMechanism = prfHashMechanism;
    }

    @Override
    public String toString() {
        return Util.concatObjects(super.toString(), "\nprfHashMechanism: ", this.prfHashMechanism);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof TLS12KeyMaterialParameters)) {
            return false;
        }
        TLS12KeyMaterialParameters other = (TLS12KeyMaterialParameters)otherObject;
        return this.prfHashMechanism == other.prfHashMechanism;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.prfHashMechanism;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        try {
            Object params = constructor.newInstance((int)this.macSizeInBits, (int)this.keySizeInBits, (int)this.ivSizeInBits, this.export, this.randomInfo.getPKCS11ParamsObject(), this.prfHashMechanism);
            field_pReturnedKeyMaterial.set(params, this.returnedKeyMaterial.getPKCS11ParamsObject());
            return params;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS", ex);
        }
    }

    static {
        Field field;
        constructor = Util.getConstructor(CLASS_CK_PARAMS, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, CK_SSL3_RANDOM_DATA.class, Long.TYPE);
        try {
            Class<?> clazz = Class.forName(CLASS_CK_PARAMS, false, Parameters.class.getClassLoader());
            field = clazz.getField("pReturnedKeyMaterial");
        }
        catch (Throwable th) {
            field = null;
        }
        field_pReturnedKeyMaterial = field;
    }
}

