/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TLSMacParameters
implements Parameters {
    public static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS";
    private static final Constructor<?> constructor = Util.getConstructor("sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS", Long.TYPE, Long.TYPE, Long.TYPE);
    public long prfMechanism;
    public long macLength;
    public long serverOrClient;

    public TLSMacParameters(long prfMechanism, long macLength, long serverOrClient) {
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS is not available in the JDK");
        }
        this.prfMechanism = prfMechanism;
        this.macLength = macLength;
        this.serverOrClient = serverOrClient;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        try {
            return constructor.newInstance(this.prfMechanism, this.macLength, this.serverOrClient);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS", ex);
        }
    }

    public String toString() {
        return Util.concatObjects("prfMechanism", this.prfMechanism, "\nmacLength", this.macLength, "\nserverOrClient", this.serverOrClient);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof TLSMacParameters)) {
            return false;
        }
        TLSMacParameters other = (TLSMacParameters)otherObject;
        return this.prfMechanism == other.prfMechanism && this.macLength == other.macLength && this.serverOrClient == other.serverOrClient;
    }

    public int hashCode() {
        return (int)this.prfMechanism ^ (int)this.macLength ^ (int)this.serverOrClient;
    }
}

